;/*****************************************************************************
;
;GRAOUMF TRACKER 2
;
;Copyright (c) 1996 - 2002 Laurent de Soras
;
;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
;Contact the author : laurent@ohmforce.com
;More information about this license : http://www.gnu.org/licenses/gpl.html
;
;*****************************************************************************/



%include	"macros.asm"


;============================================================================;
;       Description: Macro de clipping d'un sample 24 bits.                  ;
;       Parametres en entree/sortie:                                         ;
;         - %{1}: Registre 32 bits contenant la valeur a clipper.            ;
;         - %{2}: Registre 32 bits contenant le peak detecte.                ;
;============================================================================;

%imacro	SPLH_clip_sample_24	2

;--- Clipping positif --------------------------------------------------------

				cmp		%{1}, 007FFFFFh
				jle		%%positive_end

				cmp		%{1}, %{2}
				jle		%%pos_peak_end

				mov		%{2}, %{1}
%%pos_peak_end

				mov		%{1}, 07FFFFFh
%%positive_end

;--- Clipping negatif --------------------------------------------------------

				cmp		%{1}, -00800000h
				jge		%%negative_end

				neg		%{1}
				cmp		%{1}, %{2}
				jle		%%neg_peak_end

				mov		%{2}, %{1}
%%neg_peak_end

				mov		%{1}, -00800000h
%%negative_end

%endmacro


				SECTION	CODE PUBLIC USE32



;============================================================================;
;       Nom: SPLH_copy_mem_8_stereo_2_24_stereo                              ;
;       Description: Copie un sample 8 bits stereo en un samples 24 bits     ;
;                    stereo.                                                 ;
;============================================================================;

				proc		SPLH_copy_mem_8_stereo_2_24_stereo

%$dest_ptr	arg
%$src_ptr	arg
%$s_length	arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		.end

				mov		edx, 4
				mov		esi, dword [ebp + %$src_ptr]
				mov		edi, dword [ebp + %$dest_ptr]
				sub		edi, edx
				xor		eax, eax							; eax = 0

.loop			movsx		eax, byte [esi]
				add		edi, edx
				sal		eax, 16
				inc		esi
				mov		dword [edi], eax

				movsx		eax, byte [esi]
				add		edi, edx
				sal		eax, 16
				inc		esi
				mov		dword [edi], eax

				dec		ecx
				jg			.loop

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_8_stereo_2_24_bimono                              ;
;       Description: Copie un sample 8 bits stereo en  2 samples 24 bits     ;
;                    mono.                                                   ;
;============================================================================;

				proc		SPLH_copy_mem_8_stereo_2_24_bimono

%$dest_1_ptr	arg
%$dest_2_ptr	arg
%$src_ptr		arg
%$s_length		arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		.end

				mov		edx, 4
				mov		esi, dword [ebp + %$src_ptr]
				mov		ebx, dword [ebp + %$dest_2_ptr]
				mov		edi, dword [ebp + %$dest_1_ptr]
				sub		ebx, edx

.loop			movsx		eax, byte [esi]
				add		ebx, edx
				sal		eax, 16
				inc		esi
				mov		dword [edi], eax

				movsx		eax, byte [esi]
				add		edi, edx
				sal		eax, 16
				inc		esi
				mov		dword [ebx], eax

				dec		ecx
				jg			.loop

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_16_stereo_2_24_bimono                             ;
;       Description: Copie un sample 16 bits stereo en 2 samples 24 bits     ;
;                    mono.                                                   ;
;============================================================================;

				proc		SPLH_copy_mem_16_stereo_2_24_bimono

%$dest_1_ptr	arg
%$dest_2_ptr	arg
%$src_ptr		arg
%$s_length		arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		.end

				mov		edx, 4
				mov		esi, dword [ebp + %$src_ptr]
				mov		ebx, dword [ebp + %$dest_2_ptr]
				mov		edi, dword [ebp + %$dest_1_ptr]
				sub		ebx, edx

.loop			movsx		eax, word [esi]
				add		ebx, edx
				inc		esi
				sal		eax, 8
				inc		esi
				mov		dword [edi], eax

				movsx		eax, word [esi]
				add		edi, edx
				inc		esi
				sal		eax, 8
				inc		esi
				mov		dword [ebx], eax

				dec		ecx
				jg			.loop

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_24_stereo_2_8_stereo                              ;
;       Description: Copie un sample 24 bits stereo en un sample  8 bits     ;
;                    stereo, et le clippe si necessaire                      ;
;============================================================================;

				proc		SPLH_copy_mem_24_stereo_2_8_stereo

%$dest_ptr	arg
%$src_ptr	arg
%$s_length	arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		.end

				mov		ebx, 4
				mov		edx, 0							; edx = valeur du peak
				mov		esi, dword [ebp + %$src_ptr]
				mov		edi, dword [ebp + %$dest_ptr]

.loop			mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 16
				mov		byte [edi], al
				add		esi, ebx
				inc		edi

				mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 16
				mov		byte [edi], al
				add		esi, ebx
				inc		edi

				dec		ecx
				jg			.loop

				mov		eax, edx

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_24_bimono_2_8_stereo                              ;
;       Description: Copie 2 samples 24 bits mono   en un sample  8 bits     ;
;                    stereo, et le clippe si necessaire                      ;
;============================================================================;

				proc		SPLH_copy_mem_24_bimono_2_8_stereo

%$dest_ptr	arg
%$src_1_ptr	arg
%$src_2_ptr	arg
%$s_length	arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		.end

				mov		edx, 0							; edx = valeur du peak
				mov		esi, dword [ebp + %$src_1_ptr]
				mov		ebx, dword [ebp + %$src_2_ptr]
				mov		edi, dword [ebp + %$dest_ptr]

.loop			mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 16
				mov		byte [edi], al
				add		esi, 4
				inc		edi

				mov		eax, dword [ebx]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 16
				mov		byte [edi], al
				add		ebx, 4
				inc		edi

				dec		ecx
				jg			.loop

				mov		eax, edx

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_24_stereo_2_16_stereo                             ;
;       Description: Copie 1 samples 24 bits stereo en un sample 16 bits     ;
;                    stereo, et le clippe si necessaire                      ;
;============================================================================;

				proc		SPLH_copy_mem_24_stereo_2_16_stereo

%$dest_ptr	arg
%$src_ptr	arg
%$s_length	arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		near .end

				mov		edx, 0							; edx = valeur du peak
				mov		ebx, 4
				mov		esi, dword [ebp + %$src_ptr]
				mov		edi, dword [ebp + %$dest_ptr]

.loop			mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 8
				mov		word [edi], ax
				add		esi, ebx
				add		edi, 2

				mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 8
				mov		word [edi], ax
				add		esi, ebx
				add		edi, 2

				dec		ecx
				jg			.loop

				mov		eax, edx

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_24_bimono_2_16_stereo                             ;
;       Description: Copie 2 samples 24 bits mono   en un sample 16 bits     ;
;                    stereo, et le clippe si necessaire                      ;
;============================================================================;

				proc		SPLH_copy_mem_24_bimono_2_16_stereo

%$dest_ptr	arg
%$src_1_ptr	arg
%$src_2_ptr	arg
%$s_length	arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		near .end

				mov		edx, 0							; edx = valeur du peak
				mov		esi, dword [ebp + %$src_1_ptr]
				mov		ebx, dword [ebp + %$src_2_ptr]
				mov		edi, dword [ebp + %$dest_ptr]

.loop			mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 8
				mov		word [edi], ax
				add		esi, 4
				add		edi, 2

				mov		eax, dword [ebx]
				SPLH_clip_sample_24	eax, edx
				sar		eax, 8
				mov		word [edi], ax
				add		ebx, 4
				add		edi, 2

				dec		ecx
				jg			.loop

				mov		eax, edx

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_24_stereo_2_24c_stereo                            ;
;       Description: Copie 1 samples 24 bits stereo en un sample 24 bits     ;
;                    stereo sur 3 octets, et le clippe si necessaire.        ;
;============================================================================;

				proc		SPLH_copy_mem_24_stereo_2_24c_stereo

%$dest_ptr	arg
%$src_ptr	arg
%$s_length	arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		near .end

				mov		edx, 0							; edx = valeur du peak
				mov		ebx, 4
				mov		esi, dword [ebp + %$src_ptr]
				mov		edi, dword [ebp + %$dest_ptr]

.loop			mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				mov		byte [edi], al
				sar		eax, 8
				mov		word [edi + 1], ax
				add		esi, ebx
				add		edi, 3

				mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				mov		byte [edi], al
				sar		eax, 8
				mov		word [edi + 1], ax
				add		esi, ebx
				add		edi, 3

				dec		ecx
				jg			.loop

				mov		eax, edx

.end
				endproc



;============================================================================;
;       Nom: SPLH_copy_mem_24_bimono_2_24c_stereo                            ;
;       Description: Copie 2 samples 24 bits mono   en un sample 24 bits     ;
;                    stereo sur 3 octets, et le clippe si necessaire.        ;
;============================================================================;

				proc		SPLH_copy_mem_24_bimono_2_24c_stereo

%$dest_ptr	arg
%$src_1_ptr	arg
%$src_2_ptr	arg
%$s_length	arg

				mov		ecx, dword [ebp + %$s_length]
				cmp		ecx, 0
				jle		near .end

				mov		edx, 0							; edx = valeur du peak
				mov		esi, dword [ebp + %$src_1_ptr]
				mov		ebx, dword [ebp + %$src_2_ptr]
				mov		edi, dword [ebp + %$dest_ptr]

.loop			mov		eax, dword [esi]
				SPLH_clip_sample_24	eax, edx
				mov		byte [edi], al
				sar		eax, 8
				mov		word [edi + 1], ax
				add		esi, 4
				add		edi, 3

				mov		eax, dword [ebx]
				SPLH_clip_sample_24	eax, edx
				mov		byte [edi], al
				sar		eax, 8
				mov		word [edi + 1], ax
				add		ebx, 4
				add		edi, 3

				dec		ecx
				jg			.loop

				mov		eax, edx

.end
				endproc



