/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"Font.h"
#include	"log.h"
#include	"memory.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Charge la fonte en memoire.                            */
/*      Parametres en entree:                                               */
/*        - filename_0: pointeur sur le nom du fichier de la fonte. Il      */
/*                      s'agit d'une image au format BMP 256 couleurs, non  */
/*                      compressee, representant 8 rangees de 32 caracteres */
/*                      chacune.                                            */
/*        - size_x, size_y: taille en pixel de chaque caractere.            */
/*==========================================================================*/

Font::Font (void)
{
	_data_ptr = NULL;
	_size_x = 0;
	_size_y = 0;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Libere la fonte chargee en memoire.                    */
/*==========================================================================*/

Font::~Font ()
{
	restore ();
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	Font::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("Font::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	if (_data_ptr == NULL && (_size_x != 0 || _size_y != 0))
	{
		LOG_printf ("Font::check_ok: Error: font not loaded correctly.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	Font::self_display (void) const
{

	/*** A faire ***/

}



void	Font::restore (void)
{
	if (_data_ptr != NULL)
	{
		FREE (_data_ptr);
		_data_ptr = NULL;
	}
	_size_x = 0;
	_size_y = 0;
}



signed int	Font::set_font (int size_x, int size_y, const UBYTE *bitmap_ptr)
{
	UBYTE		*font_ptr;
	UBYTE		val;
	int		char_line;
	int		char_col;
	int		x;
	int		y;

	restore ();

	_data_ptr = (UBYTE *) MALLOC ((long)size_x*size_y*256);
	if (_data_ptr == NULL)
	{
		LOG_printf ("Font::set_font: Error: unable to allocate memory for font data.\n");
		return (-1);
	}

	font_ptr = _data_ptr;

	for (char_line = 0; char_line < 8; char_line ++)
	{
		for (char_col = 0; char_col < 32; char_col ++)
		{
			for (y = 0; y < size_y; y ++)
			{
				for (x = 0; x < size_x; x ++)
				{
					val = bitmap_ptr [    (  (char_line * size_y + y) * 32
					                       + char_col)
					                    * size_x
					                  + x];
					*font_ptr++ = ((val != 0) ? 1 : 0);
				}
			}
		}
	}

	_size_x = size_x;
	_size_y = size_y;

	return (0);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
