/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#define	WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>

#include	"base_ct.h"
#include	"log.h"
#include	"Mutex.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

Mutex::Mutex (void)
{
	_count = 0;
	_handle = CreateMutex (NULL, FALSE, NULL);
	if (_handle == NULL)
	{
		LOG_printf ("Mutex::Mutex: Error: couldn't create mutex.\n");
	}
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

Mutex::~Mutex (void)
{
	if (_handle != NULL)
	{
		CloseHandle (_handle);
		_handle = NULL;
	}
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	Mutex::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("Mutex::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	Mutex::self_display (void) const
{

	/*** A faire ***/

}



signed int	Mutex::wait (void)
{
	if (WaitForSingleObject (_handle, INFINITE) == WAIT_FAILED)
	{
		LOG_printf ("Mutex::wait: Error: Couldn't wait for mutex.\n");
		return (-1);
	}

	_count ++;

	return (0);
}



signed int	Mutex::signal (void)
{
	if (ReleaseMutex (_handle) == 0)
	{
		LOG_printf ("Mutex::signal: Error: Couldn't release mutex.\n");
		return (-1);
	}

	_count --;

	return (0);
}



signed int	Mutex::wait_multiple (int nbr_mutex, Mutex *mutex_ptr_array [])
{
	HANDLE	handle_array [MAXIMUM_WAIT_OBJECTS];
	int		cnt;

	if (nbr_mutex > 0)
	{
		if (nbr_mutex > MAXIMUM_WAIT_OBJECTS)
		{
			LOG_printf ("Mutex::wait_multiple: Error: Too many mutex.\n");
			return (-1);
		}

		for (cnt = 0; cnt < nbr_mutex; cnt ++)
		{
			handle_array [cnt] = mutex_ptr_array [cnt]->_handle;
		}

		if (WaitForMultipleObjects (nbr_mutex, handle_array, TRUE, INFINITE) == WAIT_FAILED)
		{
			LOG_printf ("Mutex::wait_multiple: Error: Couldn't wait for mutex.\n");
			return (-1);
		}

		for (cnt = 0; cnt < nbr_mutex; cnt ++)
		{
			mutex_ptr_array [cnt]->_count ++;
		}
	}

	return (0);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
