/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base.h"
#include	"base_ct.h"
#include	"file.h"
#include	"fnames.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"PatEdMenuPrefMain.h"
#include	"Popup.h"
#include	"player.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuPrefMain::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuPrefMain::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuPrefMain::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuPrefMain::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuPrefMain::refresh (void)
{
	int		time_high;
	int		time_low;
	char		nbr2_0 [2+1];

	/* Bar division */
	PLAY_get_bar_time (time_high, time_low);
	sprintf (nbr2_0, "%2d", time_high);
	RSC_set_string (RSC_OBJ_MP_SUBM_PREF_MAIN_BAR_BOX_VAL1, nbr2_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_PREF_MAIN_BAR_BOX_VAL1);
	sprintf (nbr2_0, "%2d", time_low);
	RSC_set_string (RSC_OBJ_MP_SUBM_PREF_MAIN_BAR_BOX_VAL2, nbr2_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_PREF_MAIN_BAR_BOX_VAL2);

	/* Skin */
	if (RSC_skin_ptr->get_custom_flag ())
	{
		RSC_set_string (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_NAME_VAL, RSC_skin_ptr->get_skin_name ());
		RSC_set_string (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_CRIGHT_VAL, RSC_skin_ptr->get_skin_copyright ());
		RSC_pos_flag (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_RMV, RSC_ATTRP_DISABLE, false);
	}
	else
	{
		RSC_set_string (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_NAME_VAL, "(no custom skin)");
		RSC_set_string (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_CRIGHT_VAL, "");
		RSC_pos_flag (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_RMV, RSC_ATTRP_DISABLE, true);
	}
	RSC_display_object (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_NAME_VAL);
	RSC_display_object (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_CRIGHT_VAL);
	RSC_display_object (RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_RMV);

	/* Interdependance sample-instrument */
	RSC_select_object_display (RSC_OBJ_MP_SUBM_PREF_MAIN_ISIDEP,
	                           GTK_spl_instr_interdep_flag);

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuPrefMain::refresh_dynamic (bool force_flag)
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuPrefMain::manage (int sel_object, int sel_elder)
{
	int		i;
	int		time_high;
	int		time_low;
	int		line;
	char		nbr2_0 [2+1];
	Popup		popup_menu;
	String	path;
	String	filename;

	switch (sel_object)
	{
	/* Bar division (high) */
	case	RSC_OBJ_MP_SUBM_PREF_MAIN_BAR_BOX_VAL1:
		PLAY_get_bar_time (time_high, time_low);
		for (i = 1; i <= 16; i ++)
		{
			sprintf (nbr2_0, "%2d", i);
			popup_menu.add_line (nbr2_0, i);
		}
		line = popup_menu.select_radio_by_code (time_high);
		time_high = popup_menu.manage (line);
		PLAY_set_bar_time (time_high, 0);
		INTR_pattern_editor_track_ptr->refresh ();
		refresh ();
		break;

	/* Bar division (low) */
	case	RSC_OBJ_MP_SUBM_PREF_MAIN_BAR_BOX_VAL2:
		PLAY_get_bar_time (time_high, time_low);
		for (i = 1; i <= 16; i <<= 1)
		{
			sprintf (nbr2_0, "%2d", i);
			popup_menu.add_line (nbr2_0, i);
		}
		line = popup_menu.select_radio_by_code (time_low);
		time_low = popup_menu.manage (line);
		PLAY_set_bar_time (0, time_low);
		INTR_pattern_editor_track_ptr->refresh ();
		refresh ();
		break;

	/* Load skin */
	case	RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_LOAD:
		path = FNAM_get_full_path (FILE_misc_filename);
		filename = INTR_file_selector (path + "skin.inf", "skin.inf",
		                               "Select a skin definition file",
		                               "Skin definition file\nskin.inf\n");
		if (strcmp (filename, "") != 0)
		{
			if (FILE_file_exist (filename))
			{
				FILE_misc_filename = FNAM_get_full_path (filename);
				if (RSC_set_skin (FILE_misc_filename))
				{
					INTR_dialog_box ("LOAD SKIN", "Error: couldn't load new skin.", "Cancel", 0, 0);
				}
			}
			else
			{
				INTR_dialog_box ("LOAD SKIN",
				                 String ("Error: file doesn't exist.\n") + filename,
				                 "Cancel", 0, 0);
			}
			INTR_redraw_all ();
		}
		break;

	/* Remove skin */
	case	RSC_OBJ_MP_SUBM_PREF_MAIN_SKIN_RMV:
		if (RSC_skin_ptr->restore_standard_skin ())
		{
			INTR_dialog_box ("REMOVE SKIN", "Error: couldn't remove skin.", "Cancel", 0, 0);
		}
		else
		{
			if (INTR_graph_ptr->set_font (RSC_CHAR_W, RSC_CHAR_H,
			                              RSC_skin_ptr->get_pic_ptr (RSC_gfx_nbr [RSC_GFX_FONT])->get_data_ptr ()))
			{
				INTR_dialog_box ("REMOVE SKIN",
				                 "Error: couldn't restore font.",
				                 "Cancel", 0, 0);
			}
		}
		INTR_redraw_all ();
		break;

	/* Interdependance sample-instrument */
	case	RSC_OBJ_MP_SUBM_PREF_MAIN_ISIDEP:
		GTK_spl_instr_interdep_flag = ! GTK_spl_instr_interdep_flag;
		refresh ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuPrefMain::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_PREF_MAIN, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_PREF_PICN_MAIN, RSC_ATTR_SELECTED, activated_flag);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
