/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"file.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"mpannel.h"
#include	"PatEdMenuToolsClear.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuToolsClear::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuToolsClear::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuToolsClear::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuToolsClear::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuToolsClear::refresh (void)
{
	/* Rien de special */

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuToolsClear::refresh_dynamic (bool force_flag)
{
	/* Rien en fait */
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuToolsClear::manage (int sel_object, int sel_elder)
{
	switch (sel_object)
	{

	/* Song */
	case	RSC_OBJ_MP_SUBM_TOOLS_CLEAR_SNG:
		if (INTR_dialog_box ("CLEAR SONG",
		                     "Clear patterns and sequence ?",
									"OK\nCancel", 0, 1) == 0)
		{
			INTR_graph_ptr->mouse_bee ();
			if (GTK_clear_song ())
			{
				INTR_dialog_box ("Error",
									  "Couldn't clear song successfully.",
									  "Cancel", 0, 0);
			}
			INTR_graph_ptr->mouse_arrow ();
			MPAN_display_main_pannel ();
		}
		break;

	/* Instruments */
	case	RSC_OBJ_MP_SUBM_TOOLS_CLEAR_INS:
		if (INTR_dialog_box ("CLEAR INSTRUMENTS",
		                     "Clear instruments, envelopes and samples ?",
									"OK\nCancel", 0, 1) == 0)
		{
			INTR_graph_ptr->mouse_bee ();
			if (GTK_clear_instruments ())
			{
				INTR_dialog_box ("Error",
									  "Couldn't clear instruments successfully.",
									  "Cancel", 0, 0);
			}
			INTR_graph_ptr->mouse_arrow ();
			MPAN_display_divers ();
			refresh ();
			MPAN_display_status (true);
		}
		break;

	/* Samples */
	case	RSC_OBJ_MP_SUBM_TOOLS_CLEAR_SPL:
		if (INTR_dialog_box ("CLEAR SAMPLES",
		                     "Clear samples ?",
									"OK\nCancel", 0, 1) == 0)
		{
			INTR_graph_ptr->mouse_bee ();
			if (SAMP_clear_samples ())
			{
				INTR_dialog_box ("Error",
									  "Couldn't clear samples successfully.",
									  "Cancel", 0, 0);
			}
			INTR_graph_ptr->mouse_arrow ();
			MPAN_display_divers ();
			refresh ();
			MPAN_display_status (true);
		}
		break;

	/* Effets */
	case	RSC_OBJ_MP_SUBM_TOOLS_CLEAR_FX:
		if (INTR_dialog_box ("CLEAR FX",
		                     "Clear effect presets ?",
									"OK\nCancel", 0, 1) == 0)
		{
			INTR_graph_ptr->mouse_bee ();
			if (FXP_clear_presets ())
			{
				INTR_dialog_box ("Error",
									  "Couldn't clear effect presets successfully.",
									  "Cancel", 0, 0);
			}
			INTR_graph_ptr->mouse_arrow ();
			MPAN_display_divers ();
			refresh ();
			MPAN_display_status (true);
		}
		break;

	/* Mix */
	case	RSC_OBJ_MP_SUBM_TOOLS_CLEAR_MIX:
		if (INTR_dialog_box ("CLEAR MIX",
		                     "Clear mix presets ?",
									"OK\nCancel", 0, 1) == 0)
		{
			INTR_graph_ptr->mouse_bee ();
			if (MIXP_clear_presets ())
			{
				INTR_dialog_box ("Error",
									  "Couldn't clear mix presets successfully.",
									  "Cancel", 0, 0);
			}
			INTR_graph_ptr->mouse_arrow ();
			MPAN_display_divers ();
			refresh ();
			MPAN_display_status (true);
		}
		break;

	/* Tout */
	case	RSC_OBJ_MP_SUBM_TOOLS_CLEAR_ALL:
		if (INTR_dialog_box ("CLEAR ALL",
		                     "Clear module ?",
									"OK\nCancel", 0, 1) == 0)
		{
			INTR_graph_ptr->mouse_bee ();
			if (GTK_clear_all ())
			{
				INTR_dialog_box ("Error",
									  "Couldn't clear module successfully.",
									  "Cancel", 0, 0);
			}
			else
			{
				FILE_generate_new_module_name ();
			}
			INTR_graph_ptr->mouse_arrow ();
			MPAN_display_main_pannel ();
		}
		break;

	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuToolsClear::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_TOOLS_CLEAR, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_TOOLS_PICN_CLEAR, RSC_ATTR_SELECTED, activated_flag);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
