/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (Pattern_CURRENT_HEADER)
	#error Inclusion recursive du header Pattern.
#endif
#define	Pattern_CURRENT_HEADER

#if ! defined (Pattern_HEADER_INCLUDED)
#define	Pattern_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"mods_ct.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Types de pistes */
enum
{
	Pattern_TYPE_SPL = 0,	/* Samples */
	Pattern_TYPE_AIN,			/* Audio In */
	Pattern_TYPE_FX,			/* Effets */
	Pattern_TYPE_MID,			/* MIDI */

	Pattern_NBR_TYPES
};

#define	Pattern_NAME_LEN		16		/* Longueur du nom d'un pattern */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Pattern
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const int	NOTE_SIZE [Pattern_NBR_TYPES];



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Pattern (int number, const int tracks [Pattern_NBR_TYPES]);
~Pattern (void);
signed int	check_ok (void) const;
void		self_display (void) const;

char		*get_pattern_name (char *name_0);
void		set_pattern_name (const char *name_0);
int		get_pattern_nbr_tracks (int track_type);
void		set_pattern_nbr_tracks (int track_type, int nbr_tracks);

int		get_pattern_height ();
signed int	set_pattern_height (int nbrlines);
signed int	set_nbr_tracks (int track_type, int nbr_tracks);

void		*get_note_adr_pat (int track_type, int line, int track);
MODS_GT2_SPL_NOTE	*get_spl_note_adr_pat (int line, int track);
MODS_GT2_AIN_NOTE	*get_ain_note_adr_pat (int line, int track);
MODS_GT2_FX_NOTE	*get_fx_note_adr_pat (int line, int track);
MODS_GT2_MID_NOTE	*get_mid_note_adr_pat (int line, int track);

UWORD		get_track_command (int track_type, int line, int track);
UWORD		get_track_command_spl (int line, int track);
UWORD		get_track_command_ain (int line, int track);
UWORD		get_track_command_fx (int line, int track);
void		set_track_command (int track_type, int line, int track, UWORD command);
void		set_track_command_spl (int line, int track, UWORD command);
void		set_track_command_ain (int line, int track, UWORD command);
void		set_track_command_fx (int line, int track, UWORD command);

ULWORD	get_fx_command (int line, int track);
void		set_fx_command (int line, int track, ULWORD command);

void		clear_note (int track_type, int line, int track);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_number;
char		_name [Pattern_NAME_LEN];
int		_nbr_tracks [Pattern_NBR_TYPES];
int		_nbr_lines;

/* Pointeur sur les donnees du pattern (tableau de notes de longueur variable
   suivant le type, classees en [ligne] [piste]) */
UBYTE		*_data_ptr [Pattern_NBR_TYPES];



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void	convert_pattern (int track_type, int old_nbr_tracks, int new_nbr_tracks);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Pattern (void);
Pattern (const Pattern &other);
void		operator = (const Pattern &other);
int		operator == (const Pattern &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Pattern_CURRENT_HEADER
