/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (ReconstructionFilter_CURRENT_HEADER)
	#error Inclusion recursive du header ReconstructionFilter.
#endif
#define	ReconstructionFilter_CURRENT_HEADER

#if ! defined (ReconstructionFilter_HEADER_INCLUDED)
#define	ReconstructionFilter_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"splhandl.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class ReconstructionFilter
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
ReconstructionFilter (int width);
~ReconstructionFilter (void);
signed int	check_ok (void) const;
void		self_display (void) const;

void		resample_and_mix (const void *s_buffer_ptr, SLWORD *d_buffer_ptr,
			                  LWORD length, int s_stereo, int d_stereo,
			                  SLWORD left_volume, SLWORD right_volume,
			                  bool erase_flag, SPLH_BrokenCurveState broken_curve_state, ULWORD pos_frac,
			                  double inv_resample_factor, int nbr_s_bits);
void		clear_buffer (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

/* Largeur du sinus cardinal utilise pour le filtre (en samples, de part et
   d'autre de 0). Vaut normalement 64. Plus cette valeur est grande, plus le
	filtre est de bonne qualite mais plus le retard est important (il vaut
	d'ailleur _width / 2). */
int		_width;

/* Taille du buffer stereo en samples. Doit etre une puissance de 2. */
int		_buf_len;

/* Pointeur sur le buffer stereo qui accompagne le reechantillonnage tout au
   long des frames. Ce buffer est de la taille de _width + 1. */
double	(*_buffer_ptr) [2];

/* Poisition courante dans le buffer */
int		_buffer_pos;

/* Sert pour le click removal */
SLWORD	_old_volume [2];
double	_old_value [2];

/* Indique combien de samples destination sont touches par le dernier
	sample source du tick precedent. */
double	_last_sample_trail;
double	_last_sample_width;	// Nombre de samples destinations pour un sample source



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
ReconstructionFilter (void);
ReconstructionFilter (const ReconstructionFilter &other);
void		operator = (const ReconstructionFilter &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ReconstructionFilter_CURRENT_HEADER
