/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (Skin_CURRENT_HEADER)
	#error Inclusion recursive du header Skin.
#endif
#define	Skin_CURRENT_HEADER

#if ! defined (Skin_HEADER_INCLUDED)
#define	Skin_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"Image.h"
#include	"List.h"
#include	"String.h"
#include	"ConfigKeyValue.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Nombre maximum d'elements de decor dans une skin */
#define	Skin_MAX_NBR_ELEMENTS	1024

/* Nombre maximum d'images dans une skin */
#define	Skin_MAX_NBR_PICTURES	1024


enum
{
	Skin_RECT_TILE = 0,
	Skin_RECT_CENTER,

	Skin_NBR_RECT
};


enum Skin_SpecEltType
{
	Skin_SPEC_ELT_FRAME = 0,
	Skin_SPEC_ELT_BUTTON,
	Skin_SPEC_ELT_TEXT_FIELD,

	Skin_NBR_SPEC_ELT
};


/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	int		x;
	int		y;
	int		l;
	int		h;
} Skin_RECTANGLE;



struct Skin_TileData
{
	Skin_RECTANGLE	rect [Skin_NBR_RECT];	// 0 = Tile, 1 = Center

	Skin_TileData (void)
	{
		const Skin_RECTANGLE	init = { 1, 1, 1, 1 };

		rect [Skin_RECT_TILE] = init;
		rect [Skin_RECT_CENTER] = init;
	}
};



typedef struct
{
	Image		*pic_ptr;
	String	*current_name_ptr;
	String	*normal_name_ptr;
	Skin_TileData	tile;
} Skin_PICTURE;



typedef struct
{
	int	pic [2] [3];		// 0 = courant, 1 = normal; 1 image pour chacun des 3 etats, -1 s'il n'y a pas d'image
} Skin_ELEMENT;


struct Skin_SpecialElt
{
	int		elt;

	Skin_SpecialElt (void)
	{
		elt = -1;
	}
};



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Skin
{

private:

struct Skin_BlockData
{
	String	filename;
	Skin_TileData	tile;	// Contient les membres Tile (toujours) et Center
	bool		center_flag;

	Skin_BlockData (void)
	{
		filename = "";
		center_flag = false;
	}
};



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Skin (const char *main_path_0);
~Skin (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed long	add_pic (const char *filename_0, bool custom_flag);
signed long	merge_pic (const char *filename_0, bool custom_flag);
signed long	replace_pic (const char *filename_0, bool custom_flag, long pic);
signed long	add_elt (int pic [3]);
signed int	replace_elt (long elt, int pic [3]);
signed int	load_palette (const char *palettefile_0, LWORD palette_array [256]);
signed int	load_custom_skin (const char *skin_path_0);
signed int	restore_standard_skin (void);
void		set_tile (long pic, int type, Skin_RECTANGLE &rect);
signed long	get_pic_nbr (long elt, bool &selected_flag, bool &disable_flag);
Image		*get_pic_ptr (long pic);
Skin_SpecialElt	*get_special_elt (Skin_SpecEltType spec_type, int color_type);
const Skin_TileData	*get_tile_info (long pic);
int		map_color (int color);
const char	*get_skin_name (void);
const char	*get_skin_copyright (void);
bool		get_custom_flag (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
signed int	init (void);
void		clear_all (void);
void		clear_pic (long pic);
long		reserve_first_free_pic (void);
long		get_named_pic (const char *filename_0);
bool		is_empty_pic (long pic);

signed long	decode_key_list (List *key_list_ptr);
signed long	decode_key_color_change (List *key_list_ptr);
signed long	decode_key_color_map (List *key_list_ptr);
signed long	decode_key_default_primsec (List *key_list_ptr, int type);
signed long	decode_key_dps_element (List *key_list_ptr, int color_type, Skin_SpecEltType elt_type);
signed long	decode_key_dps_block (List *key_list_ptr, Skin_BlockData block_data [3]);
signed long	decode_key_dps_block_state (List *key_list_ptr, Skin_BlockData &block_data);
signed long	decode_key_dps_block_state_pic (ConfigKeyValue *key_val_ptr, Skin_BlockData &block_data, int nbr);
signed long	decode_key_dps_block_state_tile (ConfigKeyValue *key_val_ptr, Skin_BlockData &block_data, int nbr);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
bool		_custom_flag;					// Indique qu'on a des elements customises dans le coin
String	_skin_name;						// Nom de la skin
String	_skin_copyright;				// Informations de copyright
String	_main_path;						// Chemin principal des images
String	_skin_path;						// Chemin des images additionnelles
LWORD		_palette [256];				// Nouvelle palette
LWORD		_old_palette [256];			// Ancienne palette
UBYTE		_basic_color_map [256];		// Translation des index (surtout pour les couleurs de base)
long		_nbr_pic;						// Taille du tableau d'images. Le nombre reel d'image peut etre inferieur.
long		_nbr_elt;						// Nombre d'elements
Skin_PICTURE	_pic_array [Skin_MAX_NBR_PICTURES];	// Tableau de pointeurs sur ces images
Skin_ELEMENT	_elt_array [Skin_MAX_NBR_ELEMENTS];	// Tableau de pointeurs sur les elements (groupes d'images)
Skin_SpecialElt	_special_elt [Skin_NBR_SPEC_ELT] [2];		// Numeros des elements primaires et secondaires pour frame, button et text_field



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Skin (void);
Skin (const Skin &other);
void		operator = (const Skin &other);
int		operator == (const Skin &other) const;
int		operator != (const Skin &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Skin_CURRENT_HEADER
