/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*
Utilisation:
Le thread est lance par l'utilisateur apres la construction.
L'objet est automatiquement detruit quand le thread a fini.
Si l'objet est detruit alors que le thread est encore vivant, le destructeur
attend que le thread se finisse.
Tant que l'objet est instancie, on peut relancer le thread a volonte (il faut
toutefois attendre que le thread precedant soit fini).
*/


#if defined (Thread_CURRENT_HEADER)
	#error Inclusion recursive du header Thread.
#endif
#define	Thread_CURRENT_HEADER

#if ! defined (Thread_HEADER_INCLUDED)
#define	Thread_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

enum Thread_Priority
{
	Thread_PRIORITY_IDLE = 0,
	Thread_PRIORITY_BELOW_NORMAL,
	Thread_PRIORITY_NORMAL,
	Thread_PRIORITY_ABOVE_NORMAL,
	Thread_PRIORITY_TIME_CRITICAL
};

enum Thread_Message
{
	Thread_MESSAGE_NONE = 0,
	Thread_MESSAGE_UNKNOWN,
	Thread_MESSAGE_QUIT
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Thread
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Thread (void (*thread_function_ptr)(void));
~Thread (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed int	spawn (void);
signed int	set_priority (Thread_Priority priority);
Thread_Priority	get_priority (void) const;
bool		is_running (void) const;

signed int	post_message (Thread_Message message);
Thread_Message	get_message (void);

static void	sleep (long time_ms);
static void __cdecl	redirect (void *thread_ptr);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
volatile HANDLE	_handle;
volatile DWORD		_id;
void	(*_thread_function_ptr)(void);	// Pointeur sur la fonction executee par le thread
volatile bool		_running_flag;
volatile bool		_init_flag;
volatile Thread_Priority	_priority;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Thread (void);
Thread (const Thread &other);
void		operator = (const Thread &other);
int		operator == (const Thread &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Thread_CURRENT_HEADER
