/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"log.h"
#include	"memory.h"
#include	"patt.h"
#include	"Pattern.h"
#include	"UndoCellPatPaste.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellPatPaste::UndoCellPatPaste (int track_type, int pattern, int line, int track, int height)
{
	long		note_size;
	int		note_cnt;

	_track_type = track_type;
	_pattern = pattern;
	_line = line;
	_track = track;
	_height = height;

	note_size = Pattern::NOTE_SIZE [_track_type];
	_data_ptr = MALLOC (_height * note_size);
	if (_data_ptr != NULL)
	{
		for (note_cnt = 0; note_cnt < _height; note_cnt ++)
		{
			memcpy ((UBYTE *)_data_ptr + note_cnt * note_size,
			        PAT_get_note_adr_pat (_track_type, _pattern,
			                              _line + note_cnt, _track),
					  note_size);
		}
	}
}



UndoCellPatPaste::UndoCellPatPaste (void)
{
	_track_type = 0;
	_pattern = 0;
	_line = 0;
	_track = 0;
	_height = 0;
	_data_ptr = NULL;
}



UndoCellPatPaste::UndoCellPatPaste (const UndoCellPatPaste &other)
{
	long		note_size;

	_track_type = other._track_type;
	_pattern = other._pattern;
	_line = other._line;
	_track = other._track;
	_height = other._height;

	if (_height > 0)
	{
		note_size = Pattern::NOTE_SIZE [_track_type];
		_data_ptr = MALLOC (_height * note_size);
		memcpy (_data_ptr, other._data_ptr, _height * note_size);
	}
	else
	{
		_data_ptr = NULL;		// On ne doit normalement pas passer par ici.
	}
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

UndoCellPatPaste::~UndoCellPatPaste (void)
{
	if (_data_ptr != NULL)
	{
		FREE (_data_ptr);
		_data_ptr = NULL;
	}
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellPatPaste::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellPatPaste::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	if (_data_ptr == NULL)
	{
		LOG_printf ("UndoCellPatPaste::check_ok: Error: _data_ptr pointer is NULL.\n");
		return (-1);
	}

	MCHECK (_data_ptr);

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellPatPaste::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellPatPaste::create (void) const
{
	return (new UndoCellPatPaste ());
}



Container	*UndoCellPatPaste::clone (void) const
{
	return (new UndoCellPatPaste (*this));
}



void	UndoCellPatPaste::apply_undo (void)
{
	int		note_cnt;
	long		note_size;
	void		*temp_ptr;
	void		*note_ptr;

	note_size = Pattern::NOTE_SIZE [_track_type];

	temp_ptr = MALLOC (_height * note_size);
	if (temp_ptr == NULL)
	{
		LOG_printf ("UndoCellPatPaste::apply_undo: Error: couldn't reserve memory for Redo data.\n");
		return;
	}

	for (note_cnt = 0; note_cnt < _height; note_cnt ++)
	{
		note_ptr = PAT_get_note_adr_pat (_track_type, _pattern, _line + note_cnt, _track),
		memcpy ((UBYTE *)temp_ptr + note_cnt * note_size, note_ptr, note_size);
		memcpy (note_ptr, (UBYTE *)_data_ptr + note_cnt * note_size, note_size);
	}

	FREE (_data_ptr);
	_data_ptr = temp_ptr;
}



void	UndoCellPatPaste::apply_redo (void)
{
	apply_undo ();
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
