/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (ARCHI_CURRENT_HEADER)
	#error Inclusion recursive du header ARCHI.
#endif
#define	ARCHI_CURRENT_HEADER

#if ! defined (ARCHI_HEADER_INCLUDED)
#define	ARCHI_HEADER_INCLUDED

/*\\\ INLCUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include <limits.h>



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Type de machine utilisee: PC ou ATARI */
#define	MACHINE_TYPE_PC

#if defined (MACHINE_TYPE_ATARI)
	#define	ARCHI_MOTOROLA
	#define	OS_BYTE_ORDER		0
#elif defined (MACHINE_TYPE_PC)
	#define	ARCHI_INTEL
	#define	OS_BYTE_ORDER		1
#else
	#define	ARCHI_MOTOROLA
	#define	OS_BYTE_ORDER		0
#endif



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* 8 bits */
#if (CHAR_BIT == 8)
typedef	unsigned char			BYTE;
typedef	unsigned char			UBYTE;
typedef	signed char				SBYTE;
#else
#error Impossible de trouver un type elementaire pour BYTE !
#endif

/* 16 bits */
#if (SHRT_MAX == 0x7FFFL)
typedef	short unsigned int	WORD;
typedef	short unsigned int	UWORD;
typedef	short signed int		SWORD;
#elif (INT_MAX == 0x7FFFL)
typedef	int						WORD;
typedef	unsigned int			UWORD;
typedef	signed int				SWORD;
#else
#error Impossible de trouver un type pour WORD !
#endif

/* 32 bits */
#if (INT_MAX == 0x7FFFFFFFL)
typedef	int						LWORD;
typedef	unsigned int			ULWORD;
typedef	signed int				SLWORD;
#elif (LONG_MAX == 0x7FFFFFFFL)
typedef	long int					LWORD;
typedef	long unsigned int		ULWORD;
typedef	long signed int		SLWORD;
#else
#error Impossible de trouver un type pour LWORD !
#endif

/* 64 bits */
typedef	__int64					QWORD;
typedef	unsigned __int64		UQWORD;
typedef	signed __int64			SQWORD;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ARCHI_CURRENT_HEADER
