/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (D2D_CURRENT_HEADER)
	#error Inclusion recursive du header D2D.
#endif
#define	D2D_CURRENT_HEADER

#if ! defined (D2D_HEADER_INCLUDED)
#define	D2D_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"archi.h"
#include	"Mutex.h"
#include	"Thread.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Descripteurs du cache des samples de D2D. Ne doit pas etre accessible en
   ecriture hors du module. */
typedef struct
{
	FILE		*file_ptr;		/* Pointeur fichier qui identifie le sample qui est joue */
	void		*buffer_ptr [2];	/* Adresse des buffers. Si buffer_ptr [0] est NULL, il n'y a pas de cache reserve. */
	LWORD		buf_length [2];	/* Longueur des buffers (en samples) */
	LWORD		total_length;	/* Longueur des 2 buffers en octets */
	SLWORD	buf_pos [2];	/* Position des buffers dans le sample, en samples. Peut etre legerement negative. */
	WORD		buf_flag [2];	/* Validite des donnees des buffers */
} D2D_BUFFER_ENTRY;



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	D2D_init (void);
void	D2D_restore (void);

signed int	D2D_cache_manager_routine (void);

D2D_BUFFER_ENTRY	D2D_get_buffer_info (int track);
void	D2D_free_d2d_cache_cell (int track);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern Thread	*D2D_thread_handle_ptr;
extern volatile bool	D2D_cache_manager_is_working_flag;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef D2D_CURRENT_HEADER
