/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (FILE_CURRENT_HEADER)
	#error Inclusion recursive du header FILE.
#endif
#define	FILE_CURRENT_HEADER

#if ! defined (FILE_HEADER_INCLUDED)
#define	FILE_HEADER_INCLUDED



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"file_ct.h"
#include	"String.h"



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

int	FILE_read_string_in_file (char *buffer_0, FILE *file_ptr);

/*--------------------------------------------------------------------------*/
/*      Initialisations                                                     */
/*--------------------------------------------------------------------------*/

signed int FILE_get_program_path (void);
signed int	FILE_init (void);
void	FILE_restore (void);
void	FILE_generate_new_module_name (void);
signed int	FILE_load_init_prefs (void);
signed int	FILE_autoloading (void);

/*--------------------------------------------------------------------------*/
/*      Disk                                                                */
/*--------------------------------------------------------------------------*/

bool	FILE_drive_connected (int drive);
int	FILE_get_current_drive (void);
bool	FILE_get_first_file (const char *path_0, FILE_DIR_ENTRY *ptr_dir_entry, char *filename_0);
bool	FILE_get_next_file (FILE_DIR_ENTRY *ptr_dir_entry, char *filename_0);
signed int	FILE_get_free_disk_space (int drive, double *free, double *total);
long	FILE_get_file_length (FILE *file_ptr);
long	FILE_get_file_length (const char *filename_0);
signed int	FILE_change_file_length  (FILE *file_ptr, long length);
bool	FILE_file_exist (const char *filename_0);

signed int	FILE_backup (const char *filename_0, int nbr_backup);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern const char	FILE_path_separator_0 [];

extern String	FILE_module_filename;
extern String	FILE_sample_filename;
extern String	FILE_instrument_filename;
extern String	FILE_prefs_filename;
extern String	FILE_auto_module_filename;
extern String	FILE_misc_filename;

extern String	FILE_program_pathname;
extern String	FILE_auto_sample_pathname;

extern String	FILE_module_maskname;
extern String	FILE_song_maskname;
extern String	FILE_sample_maskname;
extern String	FILE_instrument_maskname;
extern String	FILE_prefs_maskname;
extern String	FILE_auto_sample_maskname;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FILE_CURRENT_HEADER
