/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>

#include	"base.h"
#include	"base_ct.h"
#include	"edstring.h"
#include	"fx_p.h"
#include	"FxPreset.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"rsc01.h"
#include	"Popup.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

FxPreset	*FXP_preset_ptr [1+GTK_NBRFXP_TOTAL];



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



signed int	FXP_init (void)
{
	for (int cnt = 0; cnt <= GTK_NBRFXP_TOTAL; cnt ++)
	{
		FXP_preset_ptr [cnt] = new FxPreset (cnt);
		if (FXP_preset_ptr [cnt] == NULL)
		{
			LOG_printf ("FXP_init: couldn't create effect preset # %d.\n", cnt);
			return (-1);
		}
		if (FXP_preset_ptr [cnt]->check_ok ())
		{
			LOG_printf ("FXP_init: failed to create effect preset # %d.\n", cnt);
			return (-1);
		}
	}

	return (0);
}



void	FXP_restore (void)
{
	for (int cnt = 0; cnt <= GTK_NBRFXP_TOTAL; cnt ++)
	{
		if (FXP_preset_ptr [cnt] != NULL)
		{
			delete FXP_preset_ptr [cnt];
			FXP_preset_ptr [cnt] = NULL;
		}
	}
}



/****************************************************************************/
/*                                                                          */
/*      FONCTIONS DE BASE                                                   */
/*                                                                          */
/****************************************************************************/



void	FXP_get_name (int preset, char name_0 [FxPreset_NAME_LEN+1])
{
	FXP_preset_ptr [preset]->get_name (name_0);
}



void	FXP_set_name (int preset, const char *name_0)
{
	FXP_preset_ptr [preset]->set_name (name_0);
}



int	FXP_get_number (int preset)
{
	return (FXP_preset_ptr [preset]->get_number ());
}



void	FXP_set_number (int preset, int number)
{
	FXP_preset_ptr [preset]->set_number (number);
}



int	FXP_get_effect_type (int preset)
{
	return (FXP_preset_ptr [preset]->get_effect_type ());
}



void	FXP_set_effect_type (int preset, int type)
{
	FXP_preset_ptr [preset]->set_effect_type (type);
}



const FxPreset_EFFECT_CONF	&FXP_get_parameters (int preset)
{
	return (FXP_preset_ptr [preset]->get_parameters ());
}



void	FXP_set_parameters (int preset, const FxPreset_EFFECT_CONF &conf)
{
	FXP_preset_ptr [preset]->set_parameters (conf);
	FXP_preset_ptr [preset]->validate_parameters ();
}



signed int	FXP_kill_preset (int preset)
{
	FXP_set_name (preset, "");
	FXP_set_effect_type (preset, FxPreset_TYPE_NONE);

	return (0);
}



signed int	FXP_clear_presets (void)
{
	for (int cnt = 0; cnt <= GTK_NBRFXP_TOTAL; cnt ++)
	{
		FXP_kill_preset (cnt);
	}

	return (0);
}



/****************************************************************************/
/*                                                                          */
/*      ROUTINES UTILISANT L'INTERFACE                                      */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom: FXP_set_preset_number_intr                                     */
/*      Description: Change le numero du preset d'effet courant de          */
/*                   differentes manieres. L'interface est ici mise en jeu. */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	FXP_set_preset_number_intr (int type, signed int value)
{
	int		new_value;
	signed int	line;
	signed long	code;
	char		nbr3_0 [3+1];
	char		line_0 [3 + 2 + FxPreset_NAME_LEN+1];
	Popup		popup_menu;

	new_value = GTK_fx_preset_nbr;

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		sprintf (nbr3_0, INTR_base_song_3, new_value);
		EDIT_edit_string_base (nbr3_0, RSC_OBJ_MP_SUBM_FX_GAL_PRE_NBR_VAL, 3, INTR_base_song);
		new_value = (int) strtol (nbr3_0, NULL, INTR_base_song);
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		for (int cnt = 1; cnt <= FXP_NBRFXP_MAXI; cnt ++)
		{
			sprintf (line_0, INTR_base_song_3, cnt);
			line_0 [3] = ':';
			line_0 [4] = ' ';
			FXP_get_name (cnt, line_0 + 3 + 2);
			popup_menu.add_line (line_0, cnt);
		}
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = (int) code;
		}
		break;
	}

	new_value = MIN (new_value, FXP_NBRFXP_MAXI);
	new_value = MAX (new_value, 1);
	GTK_fx_preset_nbr = new_value;
	INTR_pattern_editor_menu_ptr->refresh ();

	return (0);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
