/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"env.h"
#include	"Envelope.h"
#include	"inst.h"
#include	"play_env.h"
#include	"player.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: PLAYENV_init_all_envelopes                                     */
/*      Description: Initialisation de toutes les enveloppes d'une piste.   */
/*      Parametres en entree:                                               */
/*        - instr: numero de l'instrument qui est joue. -1 enleve toutes    */
/*                 les enveloppes.                                          */
/*      Parametres en entree/sortie:                                        */
/*        - track_info_ptr: pointeur sur les infos de la piste.             */
/*==========================================================================*/

void	PLAYENV_init_all_envelopes (PLAY_TRACK_INFO *track_info_ptr, signed int instr)
{
	int		env_type;
	int		env_nbr;

	if (instr < 0)
	{
		for (env_type = 0; env_type < Envelope_NBR_TYPES; env_type ++)
		{
			track_info_ptr->score.com_env [env_type].nbr = 0;
		}
	}

	else
	{
		for (env_type = 0; env_type < Envelope_NBR_TYPES; env_type ++)
		{
			track_info_ptr->score.com_env [env_type].nbr = INST_get_instr_env (instr, env_type);
			env_nbr = track_info_ptr->score.com_env [env_type].nbr;
			if (env_nbr > 0)
			{
				ENV_start (env_type, env_nbr,
				           track_info_ptr->score.com_env [env_type].proc);
			}
		}
	}
}



/*==========================================================================*/
/*      Nom: PLAYENV_manage_all_envelopes                                   */
/*      Description: Gere les enveloppes.                                   */
/*==========================================================================*/

void	PLAYENV_manage_all_envelopes (void)
{
	int		track;
	int		track_max;
	int		type_cnt;
	int		track_type;
	int		track_type_list [3] =
	{
		Pattern_TYPE_SPL, Pattern_TYPE_AIN, Pattern_TYPE_FX
	};

	for (type_cnt = 0; type_cnt < 3; type_cnt ++)
	{
		track_type = track_type_list [type_cnt];
		track_max = GTK_nbr_tracks [track_type];
		for (track = 0; track < track_max; track ++)
		{
			PLAYENV_manage_envelope (track_type, track, Envelope_TYPE_VOL);
			PLAYENV_manage_envelope (track_type, track, Envelope_TYPE_PAN);

			if (   track_type == Pattern_TYPE_SPL
			    || track_type == Pattern_TYPE_FX)
			{
				PLAYENV_manage_envelope (track_type, track, Envelope_TYPE_TON);
				if (track_type == Pattern_TYPE_SPL)
				{
					PLAYENV_manage_envelope (Pattern_TYPE_SPL, track, Envelope_TYPE_CUTOFF);
					PLAYENV_manage_envelope (Pattern_TYPE_SPL, track, Envelope_TYPE_RESO);
				}
			}
		}
	}
}



/*==========================================================================*/
/*      Nom: PLAYENV_manage_envelope                                        */
/*      Description: Gere une certaine enveloppe pour une piste donnee.     */
/*      Parametres en entree:                                               */
/*        - track_type: type de la piste.                                   */
/*        - track: numero de la piste a traiter.                            */
/*        - env_type: type de l'enveloppe a gerer.                          */
/*==========================================================================*/

void	PLAYENV_manage_envelope (int track_type, int track, int env_type)
{
	int		env_nbr;
	PLAY_TRACK_INFO	*track_info_ptr;

	track_info_ptr = PLAY_track_info + PLAY_track_info_list [track_type] [track];

	/* Cherche le numero de l'enveloppe */
	env_nbr = track_info_ptr->score.com_env [env_type].nbr;
	if (env_nbr > 0)
	{
		ENV_process_tick (env_type, env_nbr, track_info_ptr->score.com_env [env_type].proc);

		/* Indique que le volume final doit etre recalcule */
		if (env_type == Envelope_TYPE_VOL)
		{
			track_info_ptr->score.changed_volume_flag = true;
		}

		/* Indique que le filtre doit etre recalcule */
		if (   env_type == Envelope_TYPE_CUTOFF
		    && env_type == Envelope_TYPE_RESO)
		{
			track_info_ptr->score.changed_filter_flag = true;
		}
	}
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
