/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (PLAY_CURRENT_HEADER)
	#error Inclusion recursive du header PLAY.
#endif
#define	PLAY_CURRENT_HEADER

#if ! defined (PLAY_HEADER_INCLUDED)
#define	PLAY_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"archi.h"
#include	"Envelope.h"
#include	"FxPreset.h"
#include	"gt_limit.h"
#include	"gtracker.h"
#include	"mods_ct.h"
#include	"Pattern.h"
#include	"play_ct.h"
#include	"ReconstructionFilter.h"
#include	"splhandl.h"
#include	"tracks.h"

class	List;



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	PLAY_MIN_TEMPO			32
#define	PLAY_MAX_TEMPO			999
#define	PLAY_INIT_TEMPO		125

#define	PLAY_MIN_SPEED			1
#define	PLAY_MAX_SPEED			255
#define	PLAY_INIT_SPEED		6

#define	PLAY_MIN_TIME_HIGH	1
#define	PLAY_MAX_TIME_HIGH	16
#define	PLAY_INIT_TIME_HIGH	4

#define	PLAY_MIN_TIME_LOW		1
#define	PLAY_MAX_TIME_LOW		16
#define	PLAY_INIT_TIME_LOW	4

#define	PLAY_LIN_PER_NOTE		0x100		/* Nombre de periodes lineaires entre 2 1/2 tons */
#define	PLAY_REF_PERIOD		0x1AC0L	/* Periode Amiga de reference */
#define	PLAY_REF_LIN_PERIOD	(8L*12 * PLAY_LIN_PER_NOTE)	/* Periode lineaire de reference */
#define	PLAY_MIN_PERIOD		0x40L
#define	PLAY_MAX_PERIOD		0x1FFFFL

#define	PLAY_INIT_LINEAR_PERIOD_FLAG	true

#define	PLAY_MODE_STOP_ALL	(-1)
#define	PLAY_MODE_STOP			0
#define	PLAY_MODE_SONG			1
#define	PLAY_MODE_PATTERN		2

#define	PLAY_NBR_GLOBAL_TRACKS	(GTK_NBRVOICES_MAXI + GTK_NBROUT_MAXI)

#define	PLAY_FX_RESFILT_INT_BUF_LEN	(1 << 2)	/* Taille des buffers des filtres. Doit etre une puissance de 2. */

/* Mode d'application d'un preset de mixage */
#define	PLAY_MIX_PRESET_MASK		0x0003	/* Masque pour le test des valeurs suivantes */
#define	PLAY_MIX_PRESET_REPL		0x0000	/* Remplace les pistes par celles du nouveau preset (exclusion mutuelle) */
#define	PLAY_MIX_PRESET_ADD		0x0001	/* Ajoute les pistes a celles deja existantes (exclusion mutuelle) */
#define	PLAY_MIX_PRESET_NO_MOD	0x0002	/* Ne change pas la config des entrees (ne modifie que leurs parametres) (exclusion mutuelle) */

#define	PLAY_MIX_PRESET_NO_DEST	0x0004	/* N'affecte pas les parametres de la piste destination */
#define	PLAY_MIX_PRESET_NO_VOL	0x0008	/* Ne modifie pas les parametres de volume */
#define	PLAY_MIX_PRESET_NO_PAN	0x0010	/* Ne modifie pas les parametres de panning */

/* Nombres de parametres d'increment/decrement pour chaque type de fonction */
#define	PLAY_FX_NBR_TIME_SPEED	1
#define	PLAY_FX_NBR_FREQ_SPEED	2


/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*______________________________________________
 *
 * Effets
 *______________________________________________
 */

/* Delay, configuration interne */
typedef struct
{
	SLWORD	*buf_ptr;	// Pointeur sur le buffer 24 bits
	LWORD		buf_len;		// Taille du buffer, en samples
	LWORD		write_pos;	// Position courante d'ecriture dans le buffer
	LWORD		delay;		// Ecart entre la position de replay et d'ecriture. <= buf_len
	ULWORD	feedback;	// 0...FFFFFFFF <-> 0...100 %
} PLAY_FX_INTERNAL_DELAY;

/* Filtres resonnants, configuration interne */
typedef struct
{
	double	l_num [3];	// Fraction rationnelle en p pour les calculs intermediaires.
	double	l_den [3];
	bool		mix_cell_flag;	// Indique qu'on doit mixer les filtrages de chaque cellule et non les superposer (pour le mode Band-Pass)
	struct
	{
		double	x_coef [3];	// Stockage des coefficients du filtre.
		double	y_coef [3];
		double	y_buffer [PLAY_FX_RESFILT_INT_BUF_LEN * 2];	// Buffers de filtrage
		SLWORD	x_buffer [PLAY_FX_RESFILT_INT_BUF_LEN * 2];
		int		nbr_coef;
		int		buffer_pos;
	}			biquad [FxPreset_RESFILT_MAX_BIQUAD];
} PLAY_FX_INTERNAL_RESFILT;

typedef struct
{
	double	g;					// Gain qui sert au coeur du log ou du sin
	double	k;					// Gain post-distorsion pour normaliser le signal
	double	p;					// Pente reele du gain secondaire
} PLAY_FX_INTERNAL_DISTO;

/* Information de mixage pour les pistes de samples */
typedef struct
{
	void		*sample_ptr;	// Adresse du sample (des donnees)
	void		*loopbuf_ptr;	// Adresse du buffer de bouclage
	LWORD		loopbuf_len;	// Taille du buffer de bouclage (sample)
	WORD		resol;			// Resolution (octets/sample)
	WORD		tracks;			// Stereo
	LWORD		reppos;			// Point de bouclage. Indique la longueur du sample si pas de boucle
	LWORD		replen;			// Longueur de la boucle. Doit etre nul si pas de boucle.
	LWORD		curpos_int;		// Position courante (int)
	ULWORD	curpos_frac;	// Position courante (frac)
	LWORD		freq;				// Frequence d'echantillonnage
	float		outperiod;		// Periode de sortie de la note
	WORD		loopmode;		// Type de bouclage (0 = rien, 1 = normal, 2 = ping-pong)
	WORD		direction;		// Sens actuel de replay (0 = forward, 1 = backward)
	bool		d2d_flag;		// Direct To Disk (flag)
	bool		interpol_flag;	// Interpolation (flag)
	ReconstructionFilter	*recons_filter_ptr;	// Pointe sur un objet de filtre de reconstruction (reechantillonnage partait), NULL sinon.

	/* Uniquement D2D */
	FILE		*file_ptr;		// Pointeur sur les informations du fichier, ou handle du fichier
	LWORD		file_data_offset;	// Offset des donnees dans le fichier
	void		*startbuf_ptr;	// Adresse du buffer de debut
	LWORD		startbuf_len;	// Longueur du buffer de debut
	LWORD		midbuf1_len;	// Longueur du buffer 1
	LWORD		midbuf2_len;	// Longueur du buffer 2

	/* Filtre resonnant */
	double	final_freq;		// Frequence reelle du filtre (avec les enveloppes).
	double	final_q;			// Resonnance reelle du filtre.
	double	coef_x [3];		// Coefficients de l'IIR
	double	coef_y [3];
	double	buffer_y [4*2];	// Buffers de l'IIR (mono ou stereo)
	SLWORD	buffer_x [4*2];
	int		buffer_pos;

	/* Click removal. Pour tous les types en fait */
	struct
	{
		SLWORD	first_value [2] [2];	// Premieres valeurs prises par le sample au tick d'avant (sans volume, 32 bits base 24). [wet/dry] [chn]
		SLWORD	last_value [2] [2];	// Dernieres valeurs prises par le sample au tick d'avant (sans volume, 32 bits base 24). [wet/dry] [chn]
		SLWORD	old_last_value [2] [2];	// Idem, pour le tick precedent.
		SPLH_BrokenCurveState		broken_curve_state;	// Indique qu'il y a eu discontinuite dans la courbe (changement de pos ou de sample)
	}			cr;
} PLAY_SPL_TRACK_INFO;

/* Information de mixage pour les pistes d'Audio In */
typedef struct
{
	/* Rien */
} PLAY_AIN_TRACK_INFO;

/* Informations de mixage pour les pistes d'Audio Out et d'effets */
typedef struct
{
	WORD		nbr_s_tracks;	/* Nombre de voies sources */
	PLAY_SOURCE_TRACK_CONF_BLOCK	track_conf [GTK_NBRVOICES_MAXI];	/* Config des sources */
} PLAY_SRC_TRACK_INFO;

/* Information de mixage pour les pistes d'effets */
typedef struct
{
	FxPreset_EFFECT_CONF	conf;	/* Configuration de l'effet, vue par la partition */
	union
	{
		PLAY_FX_INTERNAL_DELAY		delay;
		PLAY_FX_INTERNAL_RESFILT	resfilt;
		PLAY_FX_INTERNAL_DISTO		disto;
	}			internal;			/* Configuration interne de l'effet */
	WORD		old_effect;		/* Numero de l'ancien effet, permet de savoir quand on doit de/reinstaller les effets */
	WORD		effect;			/* Numero de l'effet */
	bool		bypass_flag;	// Indique que l'effet est court-circuite
	bool		update_flag;	/* Indique que certains parametres ou buffers doivent
									   etre recalcules avant application de l'effet. */
	bool		bad_init_flag;	/* Indique que les buffers n'ont pas pu etre alloues
									   correctement. L'init est a refaire au prochain tick
										En attendant, l'effet ne doit pas etre effectue. */
} PLAY_FX_TRACK_INFO;

/* Information sur chaque piste (mixage seulement) */
typedef struct
{
	PLAY_SPL_TRACK_INFO	spl;
	PLAY_AIN_TRACK_INFO	ain;
	PLAY_FX_TRACK_INFO	fx;
	PLAY_SRC_TRACK_INFO	src;
} PLAY_MIX_TRACK_INFO;

/* Informations sur chaque piste (partition seulement) */
typedef struct
{
	struct
	{
		WORD		note;			/* Note */
		WORD		instr;		/* Instrument */
		UWORD		effect;		/* Effet + Parametre (mot du type de la machine) */
		UWORD		effect_par;	/* Parametre de l'effet, en clair */
		WORD		volume;		/* Volume */
		ULWORD	fx_data;		/* Effet pour les pistes d'effets (mot du type de la machine) */
		LWORD		fx_par;		/* Parametre de l'effet, en clair */
		ULWORD	mid_data;	/* Donnees Midi pour les pistes MIDI (mot du type de la machine) */
	}			score;			/* Donnees directement prelevees sur la partition */

	WORD		instr;			/* Numero de l'instrument courant */
	WORD		note;				/* La note MIDI courante */
	WORD		velocity_lin;	/* Velocite de la note, lineaire 000...800 */
	WORD		velocity_log;	/* Velocite de la note, logarithmique 000...800 */
	WORD		velocity_loc;	/* Velocite locale, lineaire. Modifiee par les tremolos 000...800 */
	float		period;        /* Periode de la note */
	float		period_loc;		/* Periode locale. Modifiee par les vibratos et arpeggios */
	bool		changed_volume_flag;	// Mis a 1 si on change une composante du volume et qu'il faut le recalculer
	bool		changed_filter_flag;	// Mis a 1 si on change une composante du filtre et qu'il faut le recalculer

	struct
	{
		UWORD		volume_lin;	/* Volume de la piste, lineaire 0000...1000...FFFF */
		UWORD		volume_log;	/* Volume de la piste, logarithmique 0000...C00...1000. */
		UWORD		panning;		/* Panning de la piste 0000...8000...FFFF */
		UWORD		dryvol_lin;	/* Volume dry de la piste, lineaire (FX seulement) */
		UWORD		dryvol_log;	/* Volume dry de la piste, logarithmique (FX seulement) */
		UWORD		drypan;		/* Panning dry de la piste 0000...8000...FFFF (FX seulement) */
		UWORD		lin_vol_speed;			/* Vitesse des slides de volume lineaires */
		UWORD		lin_vol_fine_speed;	/* Vitesse des fine slides de volume lineaires */
		UWORD		log_vol_speed;			/* Vitesse des slides de volume logarithmiques */
		UWORD		log_vol_fine_speed;	/* Vitesse des fine slides de volume logarithmiques */
	}			track;

	struct
	{
		WORD		number;		/* Numero du sample */
		WORD		volume;		/* Volume 000...100...FFF */
		SWORD		transp;		/* Transposition */
		SWORD		finetune;	/* Finetune */
	}			sample;			/* Sample courant */

	struct
	{
		LWORD		pos_int;		// Position entiere
		ULWORD	pos_frac;	// Position fractionnelle
	}			offset;			// Dernier parametre des commandes Sample offset

	WORD		arpeggio_cnt;	/* Compteur de l'arpeggio */

	struct
	{
		WORD		note;			/* Note MIDI a atteindre */
		float		period;		/* Periode a atteindre ...1AC0... */
		WORD		speed;		/* Vitesse 0...FF0 */
		WORD		fine_speed;	/* Vitesse du Fine Tone Portamento */
	}			porta;			/* Portamento et Tone Portamento */

	struct
	{
		UBYTE		speed;		/* Vitesse 0...40 */
		UBYTE		cnt;			/* Compteur 0...FF */
		UBYTE		amp;			/* Amplitude 0...F */
		UBYTE		waveform;	/* Forme d'onde 0...3 */
	}			vibrato;

	struct
	{
		UBYTE		speed;		/* Vitesse 0...40 */
		UBYTE		cnt;			/* Compteur 0...FF */
		UBYTE		amp;			/* Amplitude 0...F */
		UBYTE		waveform;	/* Forme d'onde 0...3 */
	}			tremolo;

	struct
	{
		WORD			cnt;		/* Compteur */
		UBYTE			on;		/* Nombre de ticks pendant lesquels la note est active */
		UBYTE			period;	/* Periode totale ( >= on) */
	}			tremor;

	struct
	{
		UBYTE		speed;		/* Vitesse */
		UBYTE		cnt;			/* Compteur */
		SWORD		nbr;			/* Nombre de roulement restant a jouer. Negatif: pas de limite. */
	}			roll;				/* Roulements */

	struct
	{
		WORD		play;			/* Nombre de ticks avant de jouer la note */
		WORD		cut;			/* Nombre de ticks avant de couper la note */
	}			delay;

	struct
	{
		SWORD		songpos;		/* Position de repetition. Si elle est negative, aucun debut de boucle n'a ete enregistre. */
		WORD		linepos;		/* Ligne de repetition */
		WORD		cnt;			/* Compteur */
	}			ploop;			/* Pattern Loop */

	struct
	{
		WORD		speed;		/* Vitesse du Volume Slide */
		WORD		fine_speed;	/* Vitesse du Fine Volume Slide */
	}			vol_slide;

	struct
	{
		WORD		speed;		/* Vitesse du Panning Slide */
	}			pan_slide;

	struct
	{
		bool		filter_flag;	// Indique que le filtre est actif
		bool		freq_vol_flag;	// Indique que la velocite influe sur la frequence
		bool		q_vol_flag;	// Indique que la velocite influe sur la resonnance
		double	freq [2];	// Frequences aux volumes max et min. <= 20.0 : multiple de la frequence de la note
		double	q [2];		// Resonnance aux volumes max et min
	}			lpf;				// Filtre passe-bas

	struct
	{
		UWORD		nbr;			// Numero de l'enveloppe
		Envelope_PROCESS	proc;	// Structure de donnees de l'evolution de l'enveloppe
	}			com_env [Envelope_NBR_TYPES];	/* Partie commune des enveloppes */

	struct
	{
		struct
		{
			double	speed;	/* Parametres par defaut pour des increments/decrements de temps */
			double	time;		/* Temps a atteindre en cas de portamento */
		}			time [PLAY_FX_NBR_TIME_SPEED];

		struct
		{
			double	speed;	/* Parametres par defaut pour des increments/decrements de frequence */
			double	freq;		/* Frequence a atteindre en cas de portamento */
		}			freq [PLAY_FX_NBR_FREQ_SPEED];
	}			fx;				/* Partie reservee aux effets */
} PLAY_SCORE_TRACK_INFO;

/* Informations sur chaque piste (totales) */
typedef struct
{
	PLAY_MIX_TRACK_INFO		mix;
	PLAY_SCORE_TRACK_INFO	score;
	WORD		track;			/* Numero de la piste dans sa categorie */
	WORD		track_type;		/* Type de la piste */
	WORD		stereo;			/* Stereo (1 ou 2) */
	UWORD		outvol;			/* Volume instantane de sortie 0...1000...FFFF = volume piste * velocite * enveloppes */
	UWORD		outpan;			/* Balance instantanee de sortie 0...8000...FFFF */
	UWORD		dry_outvol;		/* Volume instantane de sortie dry 0...1000...FFFF (FX seulement) */
	UWORD		dry_outpan;		/* Balance instantanee de sortie dry 0...8000...FFFF (FX seulement) */
	bool		wet_mute_flag;	/* Mute wet */
	bool		dry_mute_flag;	/* Mute dry (FX seulement) */
	char		name [TRK_NAME_LEN];	/* Nom de la piste */
} PLAY_TRACK_INFO;

/* Informations sur la partition */
typedef struct
{
	LWORD		tick_len_int;	/* Longueur du tick, en samples */
	ULWORD	tick_len_frac;	/* Longueur du tick, partie fractionnaire */
	LWORD		frame_pos_int;	/* Position de la frame courante dans le tick (en samples) */
	ULWORD	frame_pos_frac;	/* Partie fracionnaire de la position de la frame dans le tick. Ne sert que pour les caculs inter_ticks */
	LWORD		frame_len;		/* Longueur de la frame courante (en samples) */

	WORD		tempo_int;		/* Tempo (BPM), partie entiere */
	UWORD		tempo_frac;		/* Partie fractionnelle du tempo */
	WORD		frame_counter;	/* Incremente a chaque frame 0 <= counter < nbr */
	WORD		nbr_frames;		/* Nombre de frames par tick */
	WORD		time_high;		/* Nombre de temps par mesure */
	WORD		time_low;		/* Subdivision de la ronde donnant le temps. Ne peut etre qu'une puissance de 2, de 1 (ronde) a 16 (double-croche = ligne) */

	WORD		tick_counter;	/* Incremente a chaque tick. 0 <= counter < speed */
	WORD		speed;			/* Nombre de ticks par ligne */
	WORD		pattern_delay;	/* Multiplicateur - 1 de la duree de la ligne. Normalement a 0. */
	WORD		current_line;	/* Numero de la ligne actuelle */
	WORD		current_pos;	/* Numero de la position actuelle dans la partition */
	WORD		next_line;		/* Calcul de la prochaine ligne. Est mise a 0 par defaut. */
	WORD		next_pos;		/* Calcul de la prochaine position */
	bool		next_flag;		/* true indique qu'on a devie de la trajectoire habituelle et qu'on doit chercher la prochaine ligne dans next_... */
	bool		linear_period_flag;	/* true indique que la periode est lineaire (false = amiga) */

	WORD		current_pattern;	/* Numero du pattern courant */

	int		current_play_mode;	/* Mode de replay (song, pattern, stop) */
} PLAY_SCORE_INFO;



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	PLAY_read_conf (List *key_list_ptr);

signed int	PLAY_first_init (void);
void	PLAY_first_restore (void);
signed int	PLAY_second_init (void);
void	PLAY_second_restore (void);
signed int	PLAY_start_player (void);
void	PLAY_stop_player (void);
bool	PLAY_get_player_started_flag (void);

void	PLAY_add_new_track (int track_type, signed int nbr_tracks);
void	PLAY_set_replay_freq (long freq);
void	PLAY_main_interrupt (void);
void	PLAY_handle_score (void);

void	PLAY_set_new_note (PLAY_TRACK_INFO *track_info_ptr);
void	PLAY_set_lin_velocity (PLAY_TRACK_INFO *track_info_ptr, int velo);
void	PLAY_set_log_velocity (PLAY_TRACK_INFO *track_info_ptr, int velo);
void	PLAY_set_lin_volume (PLAY_TRACK_INFO *track_info_ptr, long lin_vol);
void	PLAY_set_log_volume (PLAY_TRACK_INFO *track_info_ptr, int log_vol);
void	PLAY_set_dry_lin_volume (PLAY_TRACK_INFO *track_info_ptr, long lin_vol);
void	PLAY_set_dry_log_volume (PLAY_TRACK_INFO *track_info_ptr, int log_vol);
void	PLAY_set_period (PLAY_TRACK_INFO *track_info_ptr, float period);
void	PLAY_set_panning (PLAY_TRACK_INFO *track_info_ptr, bool dry_flag, long pan);

/*--------------------------------------------------------------------------*/
/*      Interfacage avec l'exterieur                                        */
/*--------------------------------------------------------------------------*/

int	PLAY_get_play_mode (void);
void	PLAY_set_play_mode (signed int play_mode, signed int position, signed int line, bool cont_flag);
void	PLAY_wait_for_new_play_mode (void);
void	PLAY_clear_all_effects (void);
void	PLAY_silence_all_effect_buffers (void);
int	PLAY_get_song_position (void);
void	PLAY_set_song_position (int songpos);
int	PLAY_get_line_position (void);
void	PLAY_set_line_position (int linepos);
int	PLAY_get_current_tick (void);
void	PLAY_reset_mix_parameters (void);
signed int	PLAY_add_source_track (int track_type, int track_nbr, const PLAY_SOURCE_TRACK_CONF_BLOCK *new_track_conf_ptr, int flags);
signed int	PLAY_change_source_track (int track_type, int track_nbr, int position, const PLAY_SOURCE_TRACK_CONF_BLOCK *new_track_conf_ptr);
signed int	PLAY_remove_source_track (int track_type, int track_nbr, const PLAY_SOURCE_TRACK_CONF_BLOCK *new_track_conf_ptr);
bool	PLAY_check_track_validity (int track_type, int track_nbr);
signed int	PLAY_check_track_is_in_sources (int track_type, int track_nbr, int *position_ptr, const PLAY_SOURCE_TRACK_CONF_BLOCK *new_track_conf_ptr);
signed int	PLAY_find_track_to_add (int track_type, int track_nbr, PLAY_SOURCE_TRACK_CONF_BLOCK *new_track_conf_ptr);
bool	PLAY_find_track_loop (int track, int track_to_find);
signed int	PLAY_get_track_nbr_s_tracks (int track_type, int track_nbr, int *nbr_s_tracks_ptr, PLAY_SOURCE_TRACK_CONF_BLOCK **track_conf_ptr_ptr);
signed int	PLAY_load_mix_preset (int track_type, int track_nbr, int preset_nbr, int flags);
signed int	PLAY_save_mix_preset (int track_type, int track_nbr, int preset_nbr);
signed int	PLAY_update_aou_source_tracks_with_aou_source_conf (int track_nbr);
signed int	PLAY_update_aou_source_conf_with_aou_source_tracks (int track_nbr);
void	PLAY_get_track_name (int track_type, int track_nbr, char *name_0);
void	PLAY_set_track_name (int track_type, int track_nbr, const char *name_0);
bool	PLAY_get_track_onoff (int track_type, int track_nbr, bool dry_flag);
void	PLAY_set_track_onoff (int track_type, int track_nbr, bool dry_flag, bool state);
LWORD	PLAY_get_track_panning (int track_type, int track_nbr, bool dry_flag);
void	PLAY_set_track_panning (int track_type, int track_nbr, bool dry_flag, LWORD pan);
LWORD	PLAY_get_track_lin_volume (int track_type, int track_nbr, bool dry_flag);
void	PLAY_set_track_lin_volume (int track_type, int track_nbr, bool dry_flag, LWORD volume);
LWORD	PLAY_get_track_log_volume (int track_type, int track_nbr, bool dry_flag);
void	PLAY_set_track_log_volume (int track_type, int track_nbr, bool dry_flag, LWORD volume);
LWORD	PLAY_lin_to_log_volume (LWORD lin_vol);
LWORD	PLAY_log_to_lin_volume (LWORD log_vol);
int	PLAY_get_track_stereo (int track_type, int track_nbr, bool dry_flag);
signed int	PLAY_set_track_stereo (int track_type, int track_nbr, int stereo);
double	PLAY_get_tempo (void);
void	PLAY_set_tempo (double tempo);
int	PLAY_get_speed (void);
void	PLAY_set_speed (int speed);
LWORD	PLAY_get_lin_master_volume (void);
void	PLAY_set_lin_master_volume (LWORD vol);
LWORD	PLAY_get_log_master_volume (void);
void	PLAY_set_log_master_volume (LWORD vol);
bool	PLAY_get_interpolation_flag (int track);
void	PLAY_set_interpolation_flag (int track, bool interpol_flag);
void	PLAY_no_mute (void);
void	PLAY_invert_all_mute (void);
void	PLAY_default_interpolation (void);
SLWORD	PLAY_get_clipping_level (int track);
void	PLAY_set_clipping_level (int track, SLWORD level);
SLWORD	PLAY_get_max_clipping_level (void);
void	PLAY_set_max_clipping_level (SLWORD level);
void	PLAY_get_bar_time (int &high, int &low);
void	PLAY_set_bar_time (int high, int low);
int	PLAY_get_bar_length (void);
signed int	PLAY_get_fx_preset (int track, int preset);
signed int	PLAY_set_fx_preset (int track, int preset, long auto_val = 0);
bool	PLAY_get_bypass_flag (int track);
void	PLAY_set_bypass_flag (int track, bool bypass_flag);

void	PLAY_play_sound (int track, int sample, long start_pos);
void	PLAY_play_pattern_line_spl (void);
void	PLAY_play_pattern_line_ain (void);
void	PLAY_play_pattern_line_fx (void);
void	PLAY_play_pattern_line_mid (void);

bool	PLAY_get_linear_period_flag (void);
void	PLAY_set_linear_period_flag (bool flag);

/*--------------------------------------------------------------------------*/
/*      Divers                                                              */
/*--------------------------------------------------------------------------*/

signed int	PLAY_convert_freq_to_note (double freq, double &finetune);
double	PLAY_convert_note_to_freq (signed int note, double finetune);
double	PLAY_convert_period_to_freq (float period);
double	PLAY_convert_rel_freq_to_period (double freq);
double	PLAY_convert_period_to_rel_freq (float period);
double	PLAY_convert_period_to_rel_per (float period);
double	PLAY_convert_period_to_time (float period);
double	PLAY_convert_note_to_internal_period (int note, signed int finetune);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern bool	PLAY_default_interpolation_flag;

extern int	PLAY_track_info_list [GTK_NBR_MIX_TRACK_TYPE] [GTK_NBRVOICES_MAXI];
extern PLAY_TRACK_INFO	PLAY_track_info [PLAY_NBR_GLOBAL_TRACKS];
extern PLAY_SCORE_INFO	PLAY_score_info;

extern float	PLAY_note_period_table [(3+(GTK_NBRNOTES_MAXI-1)+3)*8];
extern float	*PLAY_note_period_table_ref;
extern SWORD	PLAY_sin_table [4] [64];

extern volatile UBYTE	PLAY_new_spl_notes [GTK_NBRVOICES_MAXI * MODS_GT2_SPL_NOTE_LEN];
extern volatile UBYTE	PLAY_new_ain_notes [GTK_NBRVOICES_MAXI * MODS_GT2_AIN_NOTE_LEN];
extern volatile UBYTE	PLAY_new_fx_notes [GTK_NBRVOICES_MAXI * MODS_GT2_FX_NOTE_LEN];
extern volatile UBYTE	PLAY_new_mid_notes [GTK_NBRVOICES_MAXI * MODS_GT2_MID_NOTE_LEN];
extern volatile UBYTE	PLAY_new_line_flag [Pattern_NBR_TYPES];
extern volatile UBYTE	PLAY_new_note_flag [Pattern_NBR_TYPES] [GTK_NBRVOICES_MAXI];



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PLAY_CURRENT_HEADER
