/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (S2D_CURRENT_HEADER)
	#error Inclusion recursive du header S2D.
#endif
#define	S2D_CURRENT_HEADER

#if ! defined (S2D_HEADER_INCLUDED)
#define	S2D_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

int	S2D_get_byte_resolution (void);
int	S2D_get_stereo (void);
long	S2D_get_frequency (void);
signed long	S2D_get_max_duration_sample (void);
int	S2D_get_songpos (int pos_type);
int	S2D_get_linepos (int pos_type);
int	S2D_get_quality (void);
int	S2D_get_window_width (void);

void	S2D_set_byte_resolution (int val);
void	S2D_set_stereo (int val);
void	S2D_set_quality (int quality);
void	S2D_set_window_width (int width);

void	S2D_set_songpos_intr (int type, signed int value, int pos_type);
void	S2D_set_linepos_intr (int type, signed int value, int pos_type);
void	S2D_set_frequency_intr (int type, SLWORD value);
void	S2D_set_max_duration_intr (int type, signed long value);
void	S2D_set_window_width_intr (int type, signed int value);

signed int	S2D_record_module (bool all_flag);
signed int	S2D_record_data (const char *filename_0, bool all_flag);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef S2D_CURRENT_HEADER
