/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (TRK_CURRENT_HEADER)
	#error Inclusion recursive du header TRK.
#endif
#define	TRK_CURRENT_HEADER

#if ! defined (TRK_HEADER_INCLUDED)
#define	TRK_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"gt_limit.h"
#include	"Pattern.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	TRK_NBRDISPVOICES_MAXI	GTK_NBRVOICES_MAXI	/* Nombre maxi de colonnes d'affichage pour les pistes */
#define	TRK_NBRONOFF_MAXI			(MIN (GTK_NBRVOICES_MAXI, 32))	/* Nombre maximum de cases On/Off affichees */
#define	TRK_NBRPRESETS_MAXI		32			/* Nombre de presets */
#define	TRK_NAME_LEN				32		/* Longueur du nom d'une piste */

/* Contenus qu'on peut trouver sur les pistes */
enum
{
	TRK_CONTENT_NOTE = 0,
	TRK_CONTENT_INSTR,
	TRK_CONTENT_COMMAND,
	TRK_CONTENT_VOLUME,
	TRK_CONTENT_EFFECT_6H,
	TRK_CONTENT_EFFECT,
	TRK_CONTENT_4H,
	TRK_CONTENT_2D,
	TRK_CONTENT_3D,
	TRK_CONTENT_INT,
	TRK_CONTENT_2H,

	TRK_NBR_CONTENTS
};

/* Types de pistes etendus: affichages different selon les notes */
enum
{
	TRK_EXT_TRACK_TYPE_FX_4H = Pattern_NBR_TYPES,	/* CCCC XXXX   CCCCVV */
	TRK_EXT_TRACK_TYPE_FX_2D,			/* CCCC DDD.DD CCCCVV */
	TRK_EXT_TRACK_TYPE_FX_3D,			/* CCCC DD.DDD CCCCVV */
	TRK_EXT_TRACK_TYPE_FX_INT,			/* CCCC DDDDD  CCCCVV */
	TRK_EXT_TRACK_TYPE_FX_N2H,			/* CCCC NNNHH CCCCVV */

	TRK_NBR_EXT_TRACK_TYPES
};

/* Type d'affichage pour les pistes de Samples */
enum
{
	TRK_DISP_TYPE_SPL_NORM = 0,		/* Normal */
	TRK_DISP_TYPE_SPL_COND,				/* Condense */
	TRK_DISP_TYPE_SPL_EXP,				/* Expanse */
	TRK_DISP_TYPE_SPL_HYB,				/* Hybride */
	TRK_NBR_DISP_TYPE_SPL
};

/* Type d'affichage pour les pistes Audio In */
enum
{
	TRK_DISP_TYPE_AIN_NORM = 0,		/* Normal */
	TRK_NBR_DISP_TYPE_AIN
};

/* Type d'affichage pour les pistes d'effets */
enum
{
	TRK_DISP_TYPE_FX_NORM = 0,		/* Normal */
	TRK_DISP_TYPE_FX_EXP,				/* Expanse */
	TRK_NBR_DISP_TYPE_FX
};

/* Type d'affichage pour les pistes MIDI */
enum
{
	TRK_DISP_TYPE_MID_NORM = 0,		/* Normal */
	TRK_NBR_DISP_TYPE_MID
};

#define	TRK_NBR_DISP_TYPE_MAX	4	/* Nombre maximum de type d'affichage pour chaque type de piste */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	WORD		track_type;		// Type des voies affichees actuellement
	WORD		nbr;				// Nombre de voies affichees
	WORD		disp_type;		// Type d'affichage
	WORD		track_nbr [TRK_NBRDISPVOICES_MAXI];	// Numero de chaque piste
} TRK_PRESET;

typedef struct
{
	int		content;			// Type de donnee
	int		space;			// Nombre d'espaces apres cette donnee
} TRK_NOTE_CONTENT;

typedef struct
{
	int		nbr_col;			// Nombre de colonnes occupees par le curseur
	int		nbr_bytes;		// Nombre d'octets utilises par l'element
	int		curs_width;		// Taille du curseur
} TRK_NOTE_ELEMENT;



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

void	TRK_init (void);
void	TRK_restore (void);

void	TRK_set_column_track (int column, int type, signed int value);
void	TRK_set_track_type (int type, signed int value);
void	TRK_set_disp_type (int type, signed int value);
void	TRK_display_mute (void);
void	TRK_activate_mute (int track);

bool	TRK_manage_tracks (void);

void	TRK_cut_block (void);
void	TRK_copy_block (void);
void	TRK_paste_block (void);

/*--------------------------------------------------------------------------*/
/*      Presets                                                             */
/*--------------------------------------------------------------------------*/

void	TRK_init_presets (void);
void	TRK_init_1_preset (int preset);
void	TRK_set_preset (int type, signed int value);
void	TRK_check_presets (void);
void	TRK_display_presets (void);
void	TRK_activate_preset (int preset);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern int	TRK_cursor_col;
extern int	TRK_cursor_pos;
extern int	TRK_cursor_offset;

extern const TRK_NOTE_ELEMENT	TRK_note_element [TRK_NBR_CONTENTS];
extern const int	TRK_cursor_last_pos [] [TRK_NBR_DISP_TYPE_MAX];
extern const int	TRK_cursor_colxpos [] [16];
extern const TRK_NOTE_CONTENT	TRK_note_content [TRK_NBR_EXT_TRACK_TYPES] [6];
extern const int	TRK_column_width [Pattern_NBR_TYPES] [TRK_NBR_DISP_TYPE_MAX];

extern int	TRK_init_display_type [Pattern_NBR_TYPES];
extern int	TRK_init_displayed_track_type;
extern int	TRK_nbr_disp_type [Pattern_NBR_TYPES];

extern TRK_PRESET	TRK_preset_data [TRK_NBRPRESETS_MAXI];
extern int	TRK_preset_nbr;

extern const char	TRK_vol_col_fx [0x10];



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef TRK_CURRENT_HEADER
