/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"ConfigKey.h"
#include	"log.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

ConfigKey::ConfigKey (const char *name_0, const ConfigKeyValue *val_ptr)
{
	_name = name_0;
	_value_ptr = (ConfigKeyValue *) val_ptr->clone ();
}



ConfigKey::ConfigKey (void)
{
	_value_ptr = NULL;
}



ConfigKey::ConfigKey (const ConfigKey &other)
{
	_name = other._name;
	_value_ptr = (ConfigKeyValue *) other._value_ptr->clone ();
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

ConfigKey::~ConfigKey (void)
{
	if (_value_ptr != NULL)
	{
		delete _value_ptr;
		_value_ptr = NULL;
	}
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	ConfigKey::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("ConfigKey::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	ConfigKey::self_display (void) const
{

	/*** A faire ***/

}



Container	*ConfigKey::create (void) const
{
	return (new ConfigKey ());
}



Container	*ConfigKey::clone (void) const
{
	return (new ConfigKey (*this));
}



void	ConfigKey::set_name (const char *name_0)
{
	_name = name_0;
}



String	ConfigKey::get_name (void) const
{
	return (_name);
}



ConfigKeyValue	*ConfigKey::get_value (void) const
{
	if (_value_ptr == NULL)
	{
		return (NULL);
	}

	return (_value_ptr);
}



signed int	ConfigKey::set_value (const ConfigKeyValue *other_ptr)
{
	if (_value_ptr != NULL)
	{
		delete _value_ptr;
		_value_ptr = NULL;
	}

	_value_ptr = (ConfigKeyValue *) other_ptr->clone ();

	return (0);
}



String	ConfigKey::get_string (void)
{
	return (get_value ()->get_string ());
}



List	*ConfigKey::get_list (void)
{
	return (get_value ()->get_list ());
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
