/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"memory.h"
#include	"PatEdMenuSamplesD2d.h"
#include	"resource.h"
#include	"rsc01.h"
#include	"samp.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/

bool	PatEdMenuSamplesD2d::same_len_flag = true;



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuSamplesD2d::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuSamplesD2d::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuSamplesD2d::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuSamplesD2d::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuSamplesD2d::refresh (void)
{
	int		nbr_bytes;
	int		nbr_tracks;
	LWORD		freq;
	char		string_0 [9+1];
	char		*filename_0;

	freq = SAMP_get_sample_freq (GTK_sample_nbr);
	nbr_tracks = SAMP_get_sample_stereo (GTK_sample_nbr);
	nbr_bytes = SAMP_get_sample_resolution (GTK_sample_nbr) >> 3;

	/* Type 1 */
	if (SAMP_get_sample_type (GTK_sample_nbr) == 1)
	{
		/* Nom du fichier */
		filename_0 = STRDUP (SAMP_get_sample_d2d_filename (GTK_sample_nbr));
		if (filename_0 != NULL)
		{
			RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_FNAME_VAL, filename_0);
			FREE (filename_0);
		}

		/* Buffer de debut */
		INTR_splpos_2_string (string_0, SAMP_get_sample_buffer_len (GTK_sample_nbr, 0),
									 freq, nbr_tracks, nbr_bytes);
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_SBUF_VAL, string_0);

		/* Buffer de milieu 1 */
		INTR_splpos_2_string (string_0, SAMP_get_sample_buffer_len (GTK_sample_nbr, 1),
									 freq, nbr_tracks, nbr_bytes);
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF1_VAL, string_0);

		/* Buffer de milieu 2 */
		INTR_splpos_2_string (string_0, SAMP_get_sample_buffer_len (GTK_sample_nbr, 2),
									 freq, nbr_tracks, nbr_bytes);
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF2_VAL, string_0);

		/* Offset des donnees dans le fichier */
		sprintf (string_0, "%8ld", SAMP_get_sample_file_data_offset (GTK_sample_nbr));
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_DOFFSET_VAL, string_0);

		/* Lecture du header du fichier a l'initialisation */
		RSC_select_object_display (RSC_OBJ_MP_SUBM_SAMPLES_D2D_RFHEAD,
											SAMP_get_read_d2d_header_flag (GTK_sample_nbr));
	}

	/* Type 0 */
	else
	{
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_FNAME_VAL, "");
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_SBUF_VAL, "");
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF1_VAL, "");
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF2_VAL, "");
		RSC_set_string (RSC_OBJ_MP_SUBM_SAMPLES_D2D_DOFFSET_VAL, "");
		RSC_select_object_display (RSC_OBJ_MP_SUBM_SAMPLES_D2D_RFHEAD, false);
	}

	RSC_display_object (RSC_OBJ_MP_SUBM_SAMPLES_D2D_FNAME_VAL);
	RSC_display_object (RSC_OBJ_MP_SUBM_SAMPLES_D2D_SBUF_VAL);
	RSC_display_object (RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF1_VAL);
	RSC_display_object (RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF2_VAL);
	RSC_display_object (RSC_OBJ_MP_SUBM_SAMPLES_D2D_DOFFSET_VAL);

	/* Meme longueur pour tous les buffers */
	RSC_select_object_display (RSC_OBJ_MP_SUBM_SAMPLES_D2D_SLEN,
	                           PatEdMenuSamplesD2d::same_len_flag);

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuSamplesD2d::refresh_dynamic (bool force_flag)
{
	/* Rien en fait */
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuSamplesD2d::manage (int sel_object, int sel_elder)
{
	if (SAMP_get_sample_type (GTK_sample_nbr) != 1)
	{
		return;
	}

	switch (sel_object)
	{

	/* Nom du fichier de D2D */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_FNAME:

		/*** A faire ***/

		break;

	/* Longueur du buffer de debut */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_SBUF_VAL:
		if (RSC_mouse_key & 2)
		{
			INTR_select_splpos_unit ();
			refresh ();
		}
		else
		{
			SAMP_set_sample_d2d_buffers_intr (0, INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_SBUF_UP:
		SAMP_set_sample_d2d_buffers_intr (0, INTR_CHGTYPE_REL, INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_SBUF_DOWN:
		SAMP_set_sample_d2d_buffers_intr (0, INTR_CHGTYPE_REL, -INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	/* Longueur du buffer de milieu 1 */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF1_VAL:
		if (RSC_mouse_key & 2)
		{
			INTR_select_splpos_unit ();
			refresh ();
		}
		else
		{
			SAMP_set_sample_d2d_buffers_intr (1, INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF1_UP:
		SAMP_set_sample_d2d_buffers_intr (1, INTR_CHGTYPE_REL, INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF1_DOWN:
		SAMP_set_sample_d2d_buffers_intr (1, INTR_CHGTYPE_REL, -INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	/* Longueur du buffer de milieu 2 */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF2_VAL:
		if (RSC_mouse_key & 2)
		{
			INTR_select_splpos_unit ();
			refresh ();
		}
		else
		{
			SAMP_set_sample_d2d_buffers_intr (2, INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF2_UP:
		SAMP_set_sample_d2d_buffers_intr (2, INTR_CHGTYPE_REL, INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_MBUF2_DOWN:
		SAMP_set_sample_d2d_buffers_intr (2, INTR_CHGTYPE_REL, -INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	/* File Data Offset */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_DOFFSET_VAL:
		SAMP_set_file_data_offset_intr (INTR_CHGTYPE_KBD, 0, false);
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_DOFFSET_UP:
		SAMP_set_file_data_offset_intr (INTR_CHGTYPE_REL, INTR_inc_speed [2] [RSC_mouse_key], true);
		break;

	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_DOFFSET_DOWN:
		SAMP_set_file_data_offset_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [2] [RSC_mouse_key], true);
		break;

	/* Same length for Buffers */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_SLEN:
		PatEdMenuSamplesD2d::same_len_flag = ! PatEdMenuSamplesD2d::same_len_flag;
		refresh ();
		break;

	/* Read file header (flag) */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_RFHEAD:
		SAMP_set_read_d2d_header_flag (GTK_sample_nbr,
		                               ! SAMP_get_read_d2d_header_flag (GTK_sample_nbr));
		refresh ();
		break;

	/* Read file header (now) */
	case	RSC_OBJ_MP_SUBM_SAMPLES_D2D_READNOW:
		SAMP_read_d2d_header (GTK_sample_nbr);
		refresh ();
		break;

	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuSamplesD2d::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_SAMPLES_D2D, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_SAMPLES_PICN_D2D, RSC_ATTR_SELECTED, activated_flag);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
