/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (PatEdMenuToolsClear_CURRENT_HEADER)
	#error Inclusion recursive du header PatEdMenuToolsClear.
#endif
#define	PatEdMenuToolsClear_CURRENT_HEADER

#if ! defined (PatEdMenuToolsClear_HEADER_INCLUDED)
#define	PatEdMenuToolsClear_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"InterfaceComponent.h"

#include	<set>
#include	<string>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PatEdMenuToolsClear
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
signed int	check_ok (void) const;
void		self_display (void) const;

void		redraw (void);
void		refresh (void);
void		refresh_dynamic (bool force_flag);
void		manage (int sel_object, int sel_elder);

void		activate (bool activated_flag);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

typedef	std::set <int>	ObjSet;

void		clear_unused_patterns ();
void		clear_unused_instruments ();
void		clear_unused_samples ();
void		clear_all_unused_things ();

void		collect_non_empty_patterns (ObjSet &pat_set) const;
void		collect_patterns_used_in_song (ObjSet &pat_set) const;
void		collect_instruments_used_in_patterns (ObjSet &instr_set, const ObjSet &pat_set) const;
void		collect_sample_used_in_instruments (ObjSet &spl_set, const ObjSet &instr_set) const;

void		find_unused_patterns (ObjSet &pat_set, const ObjSet &reserved_pat_set) const;
void		find_unused_instruments (ObjSet &instr_set, const ObjSet &reserved_instr_set) const;
void		find_unused_samples (ObjSet &spl_set, const ObjSet &reserved_spl_set) const;

int		clear_all_sets (const ObjSet *pat_set_ptr, const ObjSet *instr_set_ptr, const ObjSet *spl_set_ptr);

std::string	print_clear_stat (const ObjSet *pat_set_ptr, const ObjSet *instr_set_ptr, const ObjSet *spl_set_ptr) const;



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PatEdMenuToolsClear_CURRENT_HEADER
