/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (SplEdMainLoop_CURRENT_HEADER)
	#error Inclusion recursive du header SplEdMainLoop.
#endif
#define	SplEdMainLoop_CURRENT_HEADER

#if ! defined (SplEdMainLoop_HEADER_INCLUDED)
#define	SplEdMainLoop_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"Container.h"
#include	"InterfaceComponent.h"
#include	"List.h"
#include	"SplEdCurrentSample.h"
#include	"SplEdIcons.h"
#include	"SplEdMenus.h"
#include	"SplEdMenuBar.h"
#include	"SplEdNumericDisplay.h"
#include	"SplEdVumetres.h"
#include	"SplEdWindow.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Modes d'edition (dou de representation) du sample */
enum
{
	SplEdMainLoop_MODE_NORMAL = 0,
	SplEdMainLoop_MODE_LOOP,
	SplEdMainLoop_MODE_FFT
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*** Tres sale ***/

class SplEdMainLoop_PACK_NODE
: public Container
{
public:
	int		type;		/* Type de l'element: sous-liste ou partie de l'ecran */
	union
	{
		List		*list_ptr;
		InterfaceComponent	*comp_ptr;
	}			data;

	int		check_ok (void) const { return (0); }
	void		self_display (void) const {}
	Container	*create (void) const { return (new SplEdMainLoop_PACK_NODE ()); }
	Container	*clone (void) const { return (new SplEdMainLoop_PACK_NODE (*this)); }
};



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class SplEdMainLoop
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
SplEdMainLoop (void);

void		redraw (void);
void		refresh (void);
void		refresh_dynamic (bool force_flag);
void		manage (int sel_object, int sel_elder);

int		get_width (void);
int		get_height (void);
void		set_width (int width);
void		set_height (int height);
void		pack (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static int	edit_mode;


/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		get_node_dimensions (List *list_ptr, int &width, int &height, int level);
void		pack_recursive (List *list_ptr, int x, int y, int level);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
SplEdWindow				_window;
SplEdNumericDisplay	_numdisp;
SplEdCurrentSample	_curspl;
SplEdMenuBar			_menubar;
SplEdIcons				_icons;
SplEdVumetres			_vumetres;
SplEdMenus				_menus;

List	_list_array [4];



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		operator = (const SplEdMainLoop &other);
int		operator == (const SplEdMainLoop &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SplEdMainLoop_CURRENT_HEADER
