/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdlib.h>

#include	"base.h"
#include	"config.h"
#include	"ConfigKey.h"
#include	"ConfigKeyValue.h"
#include	"List.h"
#include	"log.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



bool	CFG_get_string (const ConfigKeyValue *key_val_ptr, const char *path_0, String &str)
{
	if (! CFG_check_string (key_val_ptr, path_0))
	{
		return (false);
	}

	str = key_val_ptr->get_string ();

	return (true);
}



bool	CFG_get_bool (const ConfigKeyValue *key_val_ptr, const char *path_0, bool &val, const char *true_string_0)
{
	if (! CFG_check_string (key_val_ptr, path_0))
	{
		return (false);
	}

	String	str = key_val_ptr->get_string ();

	val = false;
	if (   BASE_compare_string (str, "true") == 0
	    || BASE_compare_string (str, "yes") == 0
	    || BASE_compare_string (str, "ok") == 0
	    || atoi (str) != 0)
	{
		val = true;
	}

	else if (true_string_0 != NULL)
	{
		if (BASE_compare_string (str, true_string_0) == 0)
		{
			val = true;
		}
	}

	return (true);
}



bool	CFG_get_int (const ConfigKeyValue *key_val_ptr, const char *path_0, int &v1)
{
	if (! CFG_check_string (key_val_ptr, path_0))
	{
		return (false);
	}

	v1 = atoi (key_val_ptr->get_string ());

	return (true);
}



bool	CFG_get_int_2 (const ConfigKeyValue *key_val_ptr, const char *path_0, int &v1, int &v2)
{
	List		*list_ptr;

	if (! CFG_check_list (key_val_ptr, path_0, 2))
	{
		return (false);
	}

	list_ptr = key_val_ptr->get_list ();

	key_val_ptr = ((ConfigKey *) list_ptr->get (0))->get_value ();
	if (CFG_get_int (key_val_ptr, String (path_0) + "/parameter 1", v1))
	{
		return (false);
	}
	key_val_ptr = ((ConfigKey *) list_ptr->get (1))->get_value ();
	if (CFG_get_int (key_val_ptr, String (path_0) + "/parameter 2", v2))
	{
		return (false);
	}

	return (true);
}



bool	CFG_get_int_3 (const ConfigKeyValue *key_val_ptr, const char *path_0, int &v1, int &v2, int &v3)
{
	List		*list_ptr;

	if (! CFG_check_list (key_val_ptr, path_0, 3))
	{
		return (false);
	}

	list_ptr = key_val_ptr->get_list ();

	key_val_ptr = ((ConfigKey *) list_ptr->get (0))->get_value ();
	if (CFG_get_int (key_val_ptr, String (path_0) + "/parameter 1", v1))
	{
		return (false);
	}
	key_val_ptr = ((ConfigKey *) list_ptr->get (1))->get_value ();
	if (CFG_get_int (key_val_ptr, String (path_0) + "/parameter 2", v1))
	{
		return (false);
	}
	key_val_ptr = ((ConfigKey *) list_ptr->get (2))->get_value ();
	if (CFG_get_int (key_val_ptr, String (path_0) + "/parameter 3", v3))
	{
		return (false);
	}

	return (true);
}



/* Noms separees par des virgules (',') */
bool	CFG_get_enum (const ConfigKeyValue *key_val_ptr, const char *path_0, int &val, const char *enum_list_0)
{
	int		new_val;

	if (! CFG_check_string (key_val_ptr, path_0))
	{
		return (false);
	}

	String	str = key_val_ptr->get_string ();
	String	enum_list (enum_list_0);
	new_val = 0;
	while (enum_list.get_len () > 0)
	{
		int	len = enum_list.find (',');
		if (len < 0)
		{
			len = enum_list.get_len ();
		}

		String	item (enum_list.left (len));
		if (BASE_compare_string (str, item) == 0)
		{
			break;
		}

		enum_list = enum_list.after (len);
		new_val ++;
	}

	if (enum_list.get_len () <= 0)
	{
		LOG_printf ("CFG_get_enum: Warning: (in \"%s\") parameter \"%s\" is not in the possible values (%s).\n",
		            path_0, (const char *) str, enum_list_0);
		return (false);
	}

	val = new_val;

	return (true);
}



bool	CFG_check_string (const ConfigKeyValue *key_val_ptr, const char *path_0)
{
	if (key_val_ptr->get_type () != ConfigKeyValue_Type_STRING)
	{
		LOG_printf ("CFG_check_string: Warning: (in \"%s\") single value expected as parameter.\n", path_0);
		return (false);
	}

	return (true);
}



bool	CFG_check_list (const ConfigKeyValue *key_val_ptr, const char *path_0, int nbr_items)
{
	if (key_val_ptr->get_type () != ConfigKeyValue_Type_LIST)
	{
		LOG_printf ("CFG_check_string: Warning: (in \"%s\") list expected as parameter.\n", path_0);
		return (false);
	}

	if (nbr_items > 0)
	{
		if (key_val_ptr->get_list ()->length () != nbr_items)
		{
			LOG_printf ("CFG_check_string: Warning: (in \"%s\") expected %d items in parameter list.\n",
			            path_0, nbr_items);
			return (false);
		}
	}

	return (true);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
