/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"gtracker.h"
#include	"log.h"
#include	"mixp.h"
#include	"MixPreset.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

MixPreset	*MIXP_preset_ptr [1+GTK_NBRMIXP_TOTAL];



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



signed int	MIXP_init (void)
{
	for (int cnt = 0; cnt <= GTK_NBRMIXP_TOTAL; cnt ++)
	{
		MIXP_preset_ptr [cnt] = new MixPreset (cnt);
		if (MIXP_preset_ptr [cnt] == NULL)
		{
			LOG_printf ("MIXP_init: couldn't create mix preset # %d.\n", cnt);
			return (-1);
		}
		if (MIXP_preset_ptr [cnt]->check_ok ())
		{
			LOG_printf ("MIXP_init: couldn't create mix preset # %d.\n", cnt);
			return (-1);
		}
	}

	return (0);
}



void	MIXP_restore (void)
{
	for (int cnt = 0; cnt <= GTK_NBRMIXP_TOTAL; cnt ++)
	{
		if (MIXP_preset_ptr [cnt] != NULL)
		{
			delete MIXP_preset_ptr [cnt];
			MIXP_preset_ptr [cnt] = NULL;
		}
	}
}



/*==========================================================================*/
/*      Nom: MIXP_get_preset_name                                           */
/*      Description: Renvoie le nom d'un preset de mixage.                  */
/*      Parametres en entree:                                               */
/*        - preset: numero du preset                                        */
/*      Parametres en sortie:                                               */
/*        - name_0: pointeur sur la chaine de caractere, terminee par un 0. */
/*                  L'esspace reserve devra etre suffisant.                 */
/*==========================================================================*/

void	MIXP_get_preset_name (int preset, char *name_0)
{
	MIXP_preset_ptr [preset]->get_preset_name (name_0);
}



/*==========================================================================*/
/*      Nom: MIXP_set_preset_name                                           */
/*      Description: Donne un nom a un preset de mixage.                    */
/*      Parametres en entree:                                               */
/*        - preset: numero du preset                                        */
/*        - name_0: pointeur sur la chaine de caractere, terminee par un 0. */
/*==========================================================================*/

void	MIXP_set_preset_name (int preset, const char *name_0)
{
	MIXP_preset_ptr [preset]->set_preset_name (name_0);
}



int	MIXP_get_track_type (int preset)
{
	return (MIXP_preset_ptr [preset]->get_track_type ());
}



void	MIXP_set_track_type (int preset, int track_type)
{
	MIXP_preset_ptr [preset]->set_track_type (track_type);
}



int	MIXP_get_track_number (int preset)
{
	return (MIXP_preset_ptr [preset]->get_track_number ());
}



void	MIXP_set_track_number (int preset, int track_nbr)
{
	MIXP_preset_ptr [preset]->set_track_number (track_nbr);
}



int	MIXP_get_nbr_source_tracks (int preset)
{
	return (MIXP_preset_ptr [preset]->get_nbr_source_tracks ());
}



signed int	MIXP_set_nbr_source_tracks (int preset, int nbr_sources)
{
	return (MIXP_preset_ptr [preset]->set_nbr_source_tracks (nbr_sources));
}



void	MIXP_get_source_track (int preset, int source, PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr)
{
	MIXP_preset_ptr [preset]->get_source_track (source, track_conf_ptr);
}



void	MIXP_set_source_track (int preset, int source, const PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr)
{
	MIXP_preset_ptr [preset]->set_source_track (source, track_conf_ptr);
}



long	MIXP_get_volume (int preset, bool dry_flag)
{
	return (MIXP_preset_ptr [preset]->get_volume (dry_flag));
}



void	MIXP_set_volume (int preset, bool dry_flag, long volume)
{
	MIXP_preset_ptr [preset]->set_volume (dry_flag, volume);
}



long	MIXP_get_panning (int preset, bool dry_flag)
{
	return (MIXP_preset_ptr [preset]->get_panning (dry_flag));
}



void	MIXP_set_panning (int preset, bool dry_flag, long panning)
{
	MIXP_preset_ptr [preset]->set_panning (dry_flag, panning);
}



int	MIXP_get_stereo (int preset)
{
	return (MIXP_preset_ptr [preset]->get_stereo ());
}



void	MIXP_set_stereo (int preset, int stereo)
{
	MIXP_preset_ptr [preset]->set_stereo (stereo);
}



signed int	MIXP_remove_source_track (int preset, int source)
{
	int		nbr_sources;
	int		src_cnt;
	PLAY_SOURCE_TRACK_CONF_BLOCK	track_conf;

	nbr_sources = MIXP_get_nbr_source_tracks (preset);
	
	if (source >= nbr_sources)
	{
		return (1);
	}

	else if (nbr_sources == 1)
	{
		MIXP_get_source_track (preset, 0, &track_conf);
		track_conf.track_type = Pattern_TYPE_SPL;
		track_conf.track_nbr = 0;
		MIXP_set_source_track (preset, 0, &track_conf);
	}

	else
	{
		for (src_cnt = source; src_cnt < nbr_sources - 1; src_cnt ++)
		{
			MIXP_get_source_track (preset, src_cnt + 1, &track_conf);
			MIXP_set_source_track (preset, src_cnt, &track_conf);
		}
		MIXP_set_nbr_source_tracks (preset, nbr_sources - 1);
	}

	return (0);
}



/* y compris le preset temporaire */
signed int	MIXP_remove_track_from_all_presets (int track_type, int track)
{
	int		preset;
	int		source;
	PLAY_SOURCE_TRACK_CONF_BLOCK	track_conf;

	for (preset = 1; preset < GTK_NBRMIXP_TOTAL; preset ++)
	{
		if (   MIXP_get_track_type (preset) == track_type
		    && MIXP_get_track_number(preset) == track)
		{
			MIXP_set_track_type (preset, GTK_TRACK_TYPE_AOU);
			MIXP_set_track_number (preset, 0);
		}

		for (source = 0; source < MIXP_get_nbr_source_tracks (preset); source ++)
		{
			MIXP_get_source_track (preset, source, &track_conf);
			if (   track_conf.track_type == track_type
			    && track_conf.track_nbr == track)
			{
				MIXP_remove_source_track (preset, source);
				source --;
			}
		}
	}

	return (0);
}



signed int	MIXP_kill_preset (int preset)
{
	return (MIXP_preset_ptr [preset]->kill_preset ());
}



/* Tue tout sauf le preset temporaire */
signed int MIXP_clear_presets (void)
{
	for (int preset = 1; preset <= MIXP_NBRMIXP_MAXI; preset ++)
	{
		if (MIXP_kill_preset (preset))
		{
			LOG_printf ("MIXP_clear_presets: Error: couldn't kill preset # %d.\n", preset);
			return (-1);
		}
	}

	return (0);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
