/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (SPLH_CURRENT_HEADER)
	#error Inclusion recursive du header SPLH.
#endif
#define	SPLH_CURRENT_HEADER

#if ! defined (SPLH_HEADER_INCLUDED)
#define	SPLH_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"SWord24.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Type de coupure de courbe, pour le decliqueur */
enum	SPLH_BrokenCurveState
{
	SPLH_BrokenCurveState_NONE = 0,
	SPLH_BrokenCurveState_START,
	SPLH_BrokenCurveState_MID
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Conversion in-situ */
void	SPLH_convert_mem_8_2_16 (void *spl_ptr, LWORD length);
void	SPLH_convert_mem_16_2_8 (void *spl_ptr, LWORD length);
signed int	SPLH_convert_file_8_2_16 (FILE *file_ptr, LWORD data_offset, LWORD length);
signed int	SPLH_convert_file_16_2_8 (FILE *file_ptr, LWORD data_offset, LWORD length);
void	SPLH_convert_mem_mono_2_stereo (void *spl_ptr, LWORD length, int resol);
void	SPLH_convert_mem_stereo_2_mono (void *spl_ptr, LWORD length, int resol);
signed int	SPLH_convert_file_mono_2_stereo (FILE *file_ptr, LWORD data_offset, LWORD length, int resol);
signed int	SPLH_convert_file_stereo_2_mono (FILE *file_ptr, LWORD data_offset, LWORD length, int resol);

/* Copie sans chevauchement avec conversion */
void	SPLH_copy_mem_8_stereo_2_24_stereo (SLWORD *dest_ptr, const SBYTE *src_ptr, LWORD length);
void	SPLH_copy_mem_8_stereo_2_24_bimono (SLWORD *dest_1_ptr, SLWORD *dest_2_ptr, const SBYTE *src_ptr, LWORD length);
void	SPLH_copy_mem_16_stereo_2_24_bimono (SLWORD *dest_1_ptr, SLWORD *dest_2_ptr, const SWORD *src_ptr, LWORD length);
SLWORD	SPLH_copy_mem_24_stereo_2_8_stereo (SBYTE *dest_ptr, const SLWORD *src_ptr, LWORD length);
SLWORD	SPLH_copy_mem_24_bimono_2_8_stereo (SBYTE *dest_ptr, const SLWORD *src_1_ptr, const SLWORD *src_2_ptr, LWORD length);
SLWORD	SPLH_copy_mem_24_stereo_2_16_stereo (SWORD *dest_ptr, const SLWORD *src_ptr, LWORD length);
SLWORD	SPLH_copy_mem_24_bimono_2_16_stereo (SWORD *dest_ptr, const SLWORD *src_1_ptr, const SLWORD *src_2_ptr, LWORD length);
SLWORD	SPLH_copy_mem_24_stereo_2_24c_stereo (SWord24 *dest_ptr, const SLWORD *src_ptr, LWORD length);
SLWORD	SPLH_copy_mem_24_bimono_2_24c_stereo (SWord24 *dest_ptr, const SLWORD *src_1_ptr, const SLWORD *src_2_ptr, LWORD length);
void	SPLH_copy_mem_invert_sample (void *dest_ptr, const void *src_ptr, LWORD length, int sample_mul);
void	SPLH_copy_mem_convert_sample_2_16 (SWORD *dest_ptr, const void *src_ptr, LWORD length, int channels, int src_resol);
void	SPLH_copy_mem_invert_convert_sample_2_16 (SWORD *dest_ptr, const void *src_ptr, LWORD length, int channels, int src_resol);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SPLH_CURRENT_HEADER
