/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (_MSC_VER)
	#pragma warning (1 : 4130) // "'operator' : logical operation on address of string constant"
	#pragma warning (1 : 4223) // "nonstandard extension used : non-lvalue array converted to pointer"
	#pragma warning (1 : 4705) // "statement has no effect"
	#pragma warning (1 : 4706) // "assignment within conditional expression"
	#pragma warning (4 : 4786) // "identifier was truncated to '255' characters in the debug information"
	#pragma warning (4 : 4800) // "forcing value to bool 'true' or 'false' (performance warning)"
	#pragma warning (4 : 4355) // "'this' : used in base member initializer list"
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"Drumpad.h"
#include	"gtracker.h"
#include	"mpannel.h"
#include	"Pattern.h"
#include	"tracks.h"

#include	<assert.h>
#include	<stdio.h>



/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



Drumpad::Drumpad ()
:	_slot_arr ()
{
	// Nothing
}



void	Drumpad::clear_all ()
{
	for (int index = 0; index < NBR_SLOTS; ++index)
	{
		Slot &			slot = _slot_arr [index];
		slot.clear ();
	}
}



bool	Drumpad::is_slot_full (int index) const
{
	assert (index >= 0);
	assert (index < NBR_SLOTS);

	const Slot &	slot = _slot_arr [index];

	return (slot._full_flag);
}



void	Drumpad::get_slot (int index, MODS_GT2_SPL_NOTE &content) const
{
	assert (index >= 0);
	assert (index < NBR_SLOTS);
	assert (&content != 0);

	const Slot &	slot = _slot_arr [index];
	assert (slot._full_flag);
	content = slot._note;
}



void	Drumpad::set_slot (int index, const MODS_GT2_SPL_NOTE &content)
{
	assert (index >= 0);
	assert (index < NBR_SLOTS);
	assert (&content != 0);

	Slot &			slot = _slot_arr [index];
	slot._full_flag = true;
	slot._note = content;
}



void	Drumpad::clear_slot (int index)
{
	assert (index >= 0);
	assert (index < NBR_SLOTS);

	Slot &			slot = _slot_arr [index];
	slot.clear ();
}



int	Drumpad::record_slot (int index)
{
	assert (index >= 0);
	assert (index < NBR_SLOTS);

	int				ret_val = 0;
	const int		track_type = TRK_preset_data [TRK_preset_nbr].track_type;

	if (track_type != Pattern_TYPE_SPL)
	{
		MPAN_display_message ("Drumpad works only on Sample tracks.");
		ret_val = -1;
	}

	else
	{
		const int		pattern = GTK_get_current_pattern_number ();
		const int		line = GTK_get_line_position ();
		const TRK_PRESET &	preset = TRK_preset_data [TRK_preset_nbr];
		const int		cursor_pos = TRK_cursor_col + TRK_cursor_offset;
		const int		track = preset.track_nbr [cursor_pos];
		const MODS_GT2_SPL_NOTE &	note =
			*PAT_get_spl_note_adr_pat (pattern, line, track);

		if (   note.note   == 0
		    && note.instr  == 0
		    && note.volume == 0
		    && note.fxnum  == 0)
		{
			MPAN_display_message ("Cannot record empty note on drumpad. Sorry !");
			ret_val = -2;
		}

		else
		{
			set_slot (index, note);
			char				txt_0 [99+1];
			sprintf (txt_0, "Note recorded in Drumpad slot #%d.", index + 1);
			MPAN_display_message (txt_0);
		}
	}

	return (ret_val);
}



int	Drumpad::restitute_slot (int index) const
{
	assert (index >= 0);
	assert (index < NBR_SLOTS);

	int				ret_val = 0;
	const int		track_type = TRK_preset_data [TRK_preset_nbr].track_type;

	if (track_type != Pattern_TYPE_SPL)
	{
		MPAN_display_message ("Drumpad works only on Sample tracks.");
		ret_val = -1;
	}

	else
	{
		const int		pattern = GTK_get_current_pattern_number ();
		const int		line = GTK_get_line_position ();
		const TRK_PRESET &	preset = TRK_preset_data [TRK_preset_nbr];
		const int		cursor_pos = TRK_cursor_col + TRK_cursor_offset;
		const int		track = preset.track_nbr [cursor_pos];
		MODS_GT2_SPL_NOTE &	note =
			*PAT_get_spl_note_adr_pat (pattern, line, track);

		get_slot (index, note);
	}

	return (ret_val);
}



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



Drumpad::Slot::Slot ()
:	_note ()
,	_full_flag (false)
{
	clear ();
}



void	Drumpad::Slot::clear ()
{
	_full_flag = false;
	_note.note = 0;
	_note.instr = 0;
	_note.volume = 0;
	_note.fxnum = 0;
	_note.fxparam = 0;
}



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
