/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (Graphic_CURRENT_HEADER)
	#error Inclusion recursive du header Graphic.
#endif
#define	Graphic_CURRENT_HEADER

#if ! defined (Graphic_HEADER_INCLUDED)
#define	Graphic_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>

#include	"archi.h"
#include	"Font.h"
#include	"Image.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Dimensions minimum acceptables pour la resolution */
#define	Graphic_MIN_WIDTH		800
#define	Graphic_MIN_HEIGHT	544



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Description d'un cadre graphique */
typedef struct
{
	WORD		x;				/* Abscisse en pixels */
	WORD		y;				/* Ordonne en pixels */
	WORD		l;				/* Largeur en pixels */
	WORD		h;				/* Hauteur en pixels */
	UBYTE		backgc;		/* Couleur du fond du cadre */
	UBYTE		nborderc;	/* Couleur du bord normal */
	UBYTE		lborderc;	/* Couleur du bord clair (haut-gauche) */
	UBYTE		sborderc;	/* Couleur du bord ombre (bas-droite) */
} Graphic_FRAME_INFO;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Graphic
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

/* Index des pricipales couleurs dans la palette de base */
static int	COL_BLACK;
static int	COL_WHITE;
static int	COL_BLUE_STD;
static int	COL_RED;

static int	COL_GREY_DARK;
static int	COL_GREY_NORMAL;
static int	COL_GREY_BRIGHT;
static int	COL_GREY_BLUE_DARK;
static int	COL_GREY_BLUE_NORMAL;
static int	COL_GREY_BLUE_BRIGHT;

static int	COL_RED_GRAD;
static int	COL_GREEN_GRAD;
static int	COL_BLUE_GRAD;
static int	COL_YELLOW_GRAD;
static int	COL_CYAN_GRAD;
static int	COL_MAGENTA_GRAD;
static int	COL_GREY_GRAD;



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Graphic (int width, int height);
~Graphic (void);
virtual signed int	check_ok (void) const;
virtual void	self_display (void) const;

bool		get_graph_mode_flag (void) const;
int		get_width (void) const;
int		get_height (void) const;

/*--------------------------------------------------------------------------*/
/*      Primitives graphiques                                               */
/*--------------------------------------------------------------------------*/

signed int	set_font (int size_x, int size_y, const UBYTE *bitmap_ptr);

void		set_palette (const LWORD palette [256]);
void		get_palette (LWORD palette [256]);
signed int	set_color (int pen, LWORD rvb);

void		display_point (int x, int y, int color);
void		display_hline (int x, int y, int l, int color);
void		display_vline (int x, int y, int h, int color);
void		display_line (int x1, int y1, int x2, int y2, int color, ULWORD pattern = 0xFFFFFFFFUL);
void		display_box (Graphic_FRAME_INFO *cadre);
void		display_xorbox (Graphic_FRAME_INFO *cadre);
void		display_string_transp (const char *text_0, int x, int y, int text_color, int max_len = 32767);
void		display_string_transp_shadow (const char *text_0, int x, int y, int text_color, int shadow_color, int max_len = 32767);
void		display_string (const char *text0, int x, int y, int text_color, int bkgnd_color = 0, int max_len = 32767);
void		display_cadre_int (Graphic_FRAME_INFO *cadre);
void		display_cadre_ext (Graphic_FRAME_INFO *cadre);
void		disable_zone (int x, int y, int l, int h, int color);
int		invert_2_colors (int x, int y, int l, int h, int color);

void		get_image (UBYTE *ptr_data, int x, int y, int l, int h);
void		put_image (const UBYTE *ptr_data, int x, int y, int l, int h);
void		put_image (const UBYTE *ptr_data, int x, int y, int l, int h, int t_color);
void		put_rectangle (const UBYTE *ptr_data, int img_w, int src_x, int src_y, int src_w, int src_h, int dest_x, int dest_y);
void		put_rectangle (const UBYTE *ptr_data, int img_w, int src_x, int src_y, int src_w, int src_h, int dest_x, int dest_y, int t_color);

Image		*save_background (int pixxpos, int pixypos, int pixwidth, int pixheight);
void		restore_background (Image *&bkgd_ptr);

bool	get_screen_lock_flag (void);
signed int	lock_screen (int x, int y, int w, int h);
signed int	unlock_screen (void);
void		paint (HDC hdc);
signed int	change_resolution (int width, int height);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static LWORD	Graphic::color_palette [256];	// Palette de 256 couleurs



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
bool		_graph_mode_flag;	/* true = mode graphique actif, false = changement */



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

signed int	init_bitmap (void);
void		restore_bitmap (void);

/*--------------------------------------------------------------------------*/
/*      Primitives graphiques                                               */
/*--------------------------------------------------------------------------*/

void	display_char (int x, int y, int c, int color, int bkgnd_color = 0);
void	display_char_transp (int x, int y, int c, int color);

long	get_imagesize (int size_x, int size_y);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

/* Pointeur sur la fonte utilisee pour l'affichage en mode graphique. */
Font		*_font_ptr;

/* Espacement en octet entre chaque debut de ligne */
int		_line_width;

HBITMAP	_bitmap_ptr;

/* Dimensions de l'ecran, en pixels */
int		_width;
int		_height;

/* Pointeur sur la memoire ecran. */
UBYTE		*_screen_ptr;

/* Flag de bloquage de l'ecran */
bool		_lock_flag;

int		_clip_xmin;
int		_clip_ymin;
int		_clip_xmax;
int		_clip_ymax;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Graphic (void);
Graphic (const Graphic &other);
void		operator = (const Graphic &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Graphic_CURRENT_HEADER
