/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (Instrument_CURRENT_HEADER)
	#error Inclusion recursive du header Instrument.
#endif
#define	Instrument_CURRENT_HEADER

#if ! defined (Instrument_HEADER_INCLUDED)
#define	Instrument_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"gt_limit.h"
#include	"Envelope.h"


/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	Instrument_NAME_LEN		28		/* Longueur du nom d'un instrument */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	UBYTE		splnum;			/* Numero de sample associe a la note */
	SBYTE		transp;			/* Transposition de ce sample */
}	Instrument_NOTE;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Instrument
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Instrument (int number);
~Instrument (void);
signed int	check_ok (void) const;
void		self_display (void) const;

void		get_instr_name (char *name_0);
void		set_instr_name (const char *name_0);
int		get_instr_volume (void);
void		set_instr_volume (int volume);
signed int	get_instr_autobal (void);
void		set_instr_autobal (signed int balance);
int		get_instr_sample (int note);
void		set_instr_sample (int note, int sample);
signed int	get_instr_transp (int note);
void		set_instr_transp (int note, signed int transp);
int		get_instr_zone_start (int note);
int		get_instr_zone_end (int note);
int		get_instr_env (int type);
void		set_instr_env (int type, int env);
bool		get_filter_flag (void) const;
void		set_filter_flag (bool flag);
bool		get_filter_freq_vol_flag (void) const;
void		set_filter_freq_vol_flag (bool flag);
bool		get_filter_q_vol_flag (void) const;
void		set_filter_q_vol_flag (bool flag);
double	get_filter_freq (int type) const;
void		set_filter_freq (int type, double val);
double	get_filter_q (int type) const;
void		set_filter_q (int type, double val);
signed int	kill (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
signed int	init (void);
void		restore (void);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_number;								// 1-...
char		_name [Instrument_NAME_LEN];
int		_volume;								// 0..100
signed int	_autobal;						// 0..800..FFF, -1 = pas d'auto
int		_env [Envelope_NBR_TYPES];		// Numeros des l'enveloppes (0 = pas d'envelope de ce type)
bool		_filter_flag;						// true = appliquer un filtre resonnant sur l'instrument
bool		_filter_freq_vol_flag;			// Ajuste automatiquement les frequences de coupure en fonction du volume
bool		_filter_q_vol_flag;				// Ajuste automatiquement le facteur de qualite en fonction du volume
double	_filter_freq [2];					// Frequences de coupure pour les velocites max et min.  <= 20.0 : multiple de la frequence de la note
double	_filter_q [2];						// Facteurs de qualite pour les velocites max et min
Instrument_NOTE	_note [GTK_NBRNOTES_MAXI];	/* Pour chaque note MIDI de 0 a 127 */



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Instrument (void);
Instrument (const Instrument &other);
void		operator = (const Instrument &other);
int		operator == (const Instrument &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Instrument_CURRENT_HEADER
