/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include	"base.h"
#include	"base_ct.h"
#include	"gtracker.h"
#include	"log.h"
#include	"memory.h"
#include	"MixPreset.h"
#include	"play_ct.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*        - number: numero du preset.                                       */
/*==========================================================================*/

MixPreset::MixPreset (int number)
{
	_number = number;

	init ();
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

MixPreset::~MixPreset (void)
{
	restore ();
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	MixPreset::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("MixPreset::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	MixPreset::self_display (void) const
{

	/*** A faire ***/

}



void	MixPreset::get_preset_name (char *name_0)
{
	BASE_copy_string (_name, name_0,
	                  MixPreset_NAME_LEN, MixPreset_NAME_LEN);
	name_0 [MixPreset_NAME_LEN] = '\0';
}



void	MixPreset::set_preset_name (const char *name_0)
{
	BASE_copy_string (name_0, _name,
	                  strlen (name_0), MixPreset_NAME_LEN);
}



int	MixPreset::get_track_type (void)
{
	return (_track_type);
}



void	MixPreset::set_track_type (int track_type)
{
	_track_type = track_type;
}



int	MixPreset::get_track_number (void)
{
	return (_track_nbr);
}



void	MixPreset::set_track_number (int track_nbr)
{
	_track_nbr = track_nbr;
}



int	MixPreset::get_nbr_source_tracks (void)
{
	return (_nbr_in);
}



signed int	MixPreset::set_nbr_source_tracks (int nbr_sources)
{
	_in_arr.resize (nbr_sources);
	for (int cnt = _nbr_in; cnt < nbr_sources; cnt ++)
	{
		_in_arr [cnt].reset ();
	}
	_nbr_in = nbr_sources;

	return (0);
}



void	MixPreset::get_source_track (int source, PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr)
{
	track_conf_ptr->track_type = _in_arr [source].track_type;
	track_conf_ptr->wet_flag = ! _in_arr [source].dry_flag;
	track_conf_ptr->track_nbr = _in_arr [source].track;
	track_conf_ptr->inpvol = _in_arr [source].volume;
	track_conf_ptr->inppan = (UWORD)_in_arr [source].balance << 4;
}



void	MixPreset::set_source_track (int source, const PLAY_SOURCE_TRACK_CONF_BLOCK *track_conf_ptr)
{
	_in_arr [source].track_type = track_conf_ptr->track_type;
	_in_arr [source].dry_flag = ! track_conf_ptr->wet_flag;
	_in_arr [source].track = track_conf_ptr->track_nbr;
	_in_arr [source].volume = track_conf_ptr->inpvol;
	_in_arr [source].balance = track_conf_ptr->inppan >> 4;
}



long	MixPreset::get_volume (bool dry_flag)
{
	if (dry_flag)
	{
		return (_vol_dry);
	}

	return (_vol_wet);
}



void	MixPreset::set_volume (bool dry_flag, long volume)
{
	if (dry_flag)
	{
		_vol_dry = (UWORD) volume;
	}
	else
	{
		_vol_wet = (UWORD) volume;
	}
}



long	MixPreset::get_panning (bool dry_flag)
{
	if (dry_flag)
	{
		return ((long)_pan_dry << 4);
	}

	return ((long)_pan_wet << 4);
}



void	MixPreset::set_panning (bool dry_flag, long panning)
{
	if (dry_flag)
	{
		_pan_dry = (int) (panning >> 4);
	}
	else
	{
		_pan_wet = (int) (panning >> 4);
	}
}



signed int	MixPreset::kill_preset (void)
{
	restore ();

	return (init ());
}



int	MixPreset::get_stereo (void)
{
	return (_stereo);
}



void	MixPreset::set_stereo (int stereo)
{
	_stereo = stereo;
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



signed int	MixPreset::init (void)
{
	memset (_name, ' ', MixPreset_NAME_LEN);
	_track_type = GTK_TRACK_TYPE_AOU;
	_track_nbr = 0;
	_nbr_in = 1;
	_pan_wet = 0x800;
	_pan_dry = 0x800;
	_vol_wet = 0x1000;
	_vol_dry = 0x1000;
	_stereo = 1;

	_in_arr.resize (_nbr_in);
	for (int cnt = 0; cnt < _nbr_in; ++cnt)
	{
		_in_arr [cnt].reset ();
	}

	return (0);
}



void	MixPreset::restore (void)
{
	_nbr_in = 0;
	SourceArr ().swap (_in_arr);
}



void	MixPreset::Source::reset ()
{
	track_type = Pattern_TYPE_SPL;
	dry_flag = false;
	track = 0;
	volume = 0x1000;
	balance = 0x800;
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
