/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (Mouse_CURRENT_HEADER)
	#error Inclusion recursive du header Mouse.
#endif
#define	Mouse_CURRENT_HEADER

#if ! defined (Mouse_HEADER_INCLUDED)
#define	Mouse_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<time.h>

#define	WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>

#include	"archi.h"
#include	"Graphic.h"
#include	"Image.h"


/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Taille de la souris */
#define	Mouse_CURS_WIDTH		16
#define	Mouse_CURS_HEIGHT		16



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	WORD		x;
	WORD		y;
	WORD		k;
	clock_t	last_pressed;
	clock_t	last_released;
} Mouse_CURRENT_STATE;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class Mouse
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const int	REFRESH_RATE;



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
Mouse (int width, int height);
~Mouse (void);
signed int	check_ok (void) const;
void		self_display (void) const;

bool		get_graph_mode_flag (void) const;
int		get_width (void) const;
int		get_height (void) const;

void		mouse_handler_routine (void);

void		get_mouse (Mouse_CURRENT_STATE *mouse_ptr);
void		set_mouse (int x, int y, int k = -1);
void		hide_mouse (void);
void		show_mouse (void);
void		mouse_arrow (void);
void		mouse_bee (void);
HCURSOR	get_current_cursor_shape (void) const;

bool		get_auto_hide_mouse_flag (void) const;
void		set_auto_hide_mouse_flag (bool flag);

/*--------------------------------------------------------------------------*/
/*      Primitives graphiques                                               */
/*--------------------------------------------------------------------------*/

signed int	set_font (int size_x, int size_y, const UBYTE *bitmap_ptr);

void		set_palette (const LWORD palette [256]);
void		get_palette (LWORD palette [256]);
signed int	set_color (int pen, LWORD rvb);

void		display_point (int x, int y, int color);
void		display_hline (int x, int y, int l, int color);
void		display_vline (int x, int y, int h, int color);
void		display_line (int x1, int y1, int x2, int y2, int color, ULWORD pattern = 0xFFFFFFFFUL);
void		display_box (Graphic_FRAME_INFO *cadre);
void		display_xorbox (Graphic_FRAME_INFO *cadre);
void		display_string_transp (const char *text_0, int x, int y, int text_color, int max_len = 32767);
void		display_string_transp_shadow (const char *text_0, int x, int y, int text_color, int shadow_color, int max_len = 32767);
void		display_string (const char *text0, int x, int y, int text_color, int bkgnd_color = 0, int max_len = 32767);
void		display_cadre_int (Graphic_FRAME_INFO *cadre);
void		display_cadre_ext (Graphic_FRAME_INFO *cadre);
void		disable_zone (int x, int y, int l, int h, int color);
int		invert_2_colors (int x, int y, int l, int h, int color);

void		get_image (UBYTE *ptr_data, int x, int y, int l, int h);
void		put_image (const UBYTE *ptr_data, int x, int y, int l, int h);
void		put_image (const UBYTE *ptr_data, int x, int y, int l, int h, int t_color);
void		put_rectangle (const UBYTE *ptr_data, int img_w, int src_x, int src_y, int src_w, int src_h, int dest_x, int dest_y);
void		put_rectangle (const UBYTE *ptr_data, int img_w, int src_x, int src_y, int src_w, int src_h, int dest_x, int dest_y, int t_color);

Image		*save_background (int pixxpos, int pixypos, int pixwidth, int pixheight);
void		restore_background (Image *&bkgd_ptr);

bool	get_screen_lock_flag (void);
signed int	lock_screen (int x, int y, int w, int h);
signed int	unlock_screen (void);
void		paint (HDC hdc);
signed int	change_resolution (int width, int height);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

/* Objet de gestion du mode graphique */
Graphic	_graph;

bool		_mouse_activated_flag;
int		_mouse_x;
int		_mouse_y;
int		_mouse_k;
int		_mouse_old_x;
int		_mouse_old_y;
bool		_mouse_displayed;
bool		_auto_hide_mouse_flag;
HCURSOR	_cursor_shape;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
Mouse (void);
Mouse (const Mouse &other);
void		operator = (const Mouse &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef Mouse_CURRENT_HEADER
