/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base.h"
#include	"base_ct.h"
#include	"log.h"
#include	"Mutex.h"
#include	"SoundDriver.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

SoundDriver::SoundDriver (void)
:	_init (NULL)
,	_restore (NULL)
,	_set_config (NULL)
,	_get_config (NULL)
,	_start_replay (NULL)
,	_stop_replay (NULL)
,	_set_new_frame (NULL)
,	_set_data (NULL)
,	_get_data (NULL)
,	_is_playing (NULL)
,	_disconnect (NULL)
,	_connect (NULL)
,	_is_connected (NULL)
,	_get_message (NULL)
,	_get_latency (NULL)
,	_set_latency (NULL)
{
	_mutex_ptr = new Mutex;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

SoundDriver::~SoundDriver (void)
{
	if (_mutex_ptr != NULL)
	{
		delete _mutex_ptr;
		_mutex_ptr = NULL;
	}
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	SoundDriver::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("SoundDriver::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	if (_mutex_ptr == NULL)
	{
		LOG_printf ("SoundDriver::check_ok: Error: _mutex_ptr pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	SoundDriver::self_display (void) const
{

	/*** A faire ***/

}



signed int	SoundDriver::init (void *param_ptr)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _init (param_ptr);
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::restore (void)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _restore ();
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::set_config (SoundDriver_CONFIG *config_ptr)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _set_config (config_ptr);
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::get_config (SoundDriver_CONFIG *config_ptr)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _get_config (config_ptr);
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::start_replay (void)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _start_replay ();
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::stop_replay (void)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _stop_replay ();
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::set_new_frame (long frame_length)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _set_new_frame (frame_length);
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::set_data (float *out_buffer_ptr [], float *out_clip_ptr)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _set_data (out_buffer_ptr, out_clip_ptr);
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::get_data (float *in_buffer_ptr [])
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _get_data (in_buffer_ptr);
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::is_playing (void)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _is_playing ();
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::disconnect (void)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _disconnect ();
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::connect (void)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _connect ();
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::is_connected (void)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _is_connected ();
	print_message ();
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::get_message (char *text_0, long max_len)
{
	signed int		ret_val;

	_mutex_ptr->wait ();
	ret_val = _get_message (text_0, max_len);
	_mutex_ptr->signal ();

	return (ret_val);
}



signed int	SoundDriver::get_latency (void)
{
	signed int		ret_val;


	_mutex_ptr->wait ();
	ret_val = _get_latency ();
	_mutex_ptr->signal ();

	ret_val = MIN (ret_val, MAX_LATENCY);
	ret_val = MAX (ret_val, 0);

	return (ret_val);
}



signed int	SoundDriver::set_latency (int t)
{
	signed int		ret_val;

	t = MIN (t, MAX_LATENCY);
	t = MAX (t, 0);

	_mutex_ptr->wait ();
	ret_val = _set_latency (t);
	_mutex_ptr->signal ();

	return (ret_val);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



void	SoundDriver::print_message (void)
{
	while (get_message (_message_buffer_0, 1023) > 0)
	{
		LOG_printf ("%s", _message_buffer_0);
	}
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
