/*****************************************************************************

        StereoGain.h
        Copyright (c) 2012 Laurent de Soras

*Tab=3***********************************************************************/



#if ! defined (StereoGain_HEADER_INCLUDED)
#define	StereoGain_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "archi.h"
#include "GainSmooth.h"



class StereoGain
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	void				push_new_mix_param (int vol, int pan);
	void				copy_without_state (const StereoGain &other);

	int				old_vol [2];	// Volume du tick precedent [wet/dry] [chn]
	int				new_vol [2];	// Volume du tick courant [wet/dry] [chn]
	GainSmooth		_gain [2];		// Applicateur de volume



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	bool				operator == (const StereoGain &other) const;
	bool				operator != (const StereoGain &other) const;

};	// class StereoGain



//#include	"StereoGain.hpp"



#endif	// StereoGain_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
