/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"gtracker.h"
#include	"Container.h"
#include	"log.h"
#include	"patt.h"
#include	"UndoCell.h"
#include	"UndoCellPatChgTrk.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellPatChgTrk::UndoCellPatChgTrk (int track_type, int nbr_tracks)
{
	_track_type = track_type;
	_nbr_tracks = nbr_tracks;
}



/* Ne devrait pas etre utilise tel quel */
UndoCellPatChgTrk::UndoCellPatChgTrk (void)
{
	_track_type = 0;
	_nbr_tracks = 0;
}



UndoCellPatChgTrk::UndoCellPatChgTrk (const UndoCellPatChgTrk &other)
{
	_track_type = other._track_type;
	_nbr_tracks = other._nbr_tracks;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

UndoCellPatChgTrk::~UndoCellPatChgTrk (void)
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellPatChgTrk::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellPatChgTrk::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellPatChgTrk::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellPatChgTrk::create (void) const
{
	return (new UndoCellPatChgTrk ());
}



Container	*UndoCellPatChgTrk::clone (void) const
{
	return (new UndoCellPatChgTrk (*this));
}



void	UndoCellPatChgTrk::apply_undo (void)
{
	int		old_nbr_tracks;

	old_nbr_tracks = GTK_nbr_tracks [_track_type];
	if (PAT_set_nbr_tracks (_track_type, _nbr_tracks))
	{
		LOG_printf ("UndoCellPatChgTrk::apply_undo: Error: Couldn't change the number of tracks.\n");
		return;
	}
	_nbr_tracks = old_nbr_tracks;
}



void	UndoCellPatChgTrk::apply_redo (void)
{
	apply_undo ();
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
