/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdlib.h>

#include	"base.h"
#include	"config.h"
#include	"ConfigKey.h"
#include	"ConfigKeyValue.h"
#include	"List.h"
#include	"log.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



bool	CFG_get_string (const ConfigKeyValue &key_val, const char *path_0, String &str)
{
	if (! CFG_check_string (key_val, path_0))
	{
		return (false);
	}

	str = key_val.get_string ();

	return (true);
}



bool	CFG_get_bool (const ConfigKeyValue &key_val, const char *path_0, bool &val, const char *true_string_0)
{
	if (! CFG_check_string (key_val, path_0))
	{
		return (false);
	}

	String	str = key_val.get_string ();

	val = false;
	if (   BASE_compare_string (str.c_str (), "true") == 0
	    || BASE_compare_string (str.c_str (), "yes") == 0
	    || BASE_compare_string (str.c_str (), "ok") == 0
	    || atoi (str.c_str ()) != 0)
	{
		val = true;
	}

	else if (true_string_0 != NULL)
	{
		if (BASE_compare_string (str.c_str (), true_string_0) == 0)
		{
			val = true;
		}
	}

	return (true);
}



bool	CFG_get_int (const ConfigKeyValue &key_val, const char *path_0, int &v1)
{
	if (! CFG_check_string (key_val, path_0))
	{
		return (false);
	}

	v1 = atoi (key_val.get_string ().c_str ());

	return (true);
}



bool	CFG_get_int_2 (const ConfigKeyValue &key_val, const char *path_0, int &v1, int &v2)
{

	if (! CFG_check_list (key_val, path_0, 2))
	{
		return (false);
	}

	const std::list <ConfigKey> &	key_list = key_val.get_list ();
	std::list <ConfigKey>::const_iterator	it = key_list.begin ();

	if (CFG_get_int (it->get_value (), (String (path_0) + "/parameter 1").c_str (), v1))
	{
		return (false);
	}
	++ it;

	if (CFG_get_int (it->get_value (), (String (path_0) + "/parameter 2").c_str (), v2))
	{
		return (false);
	}

	return (true);
}



bool	CFG_get_int_3 (const ConfigKeyValue &key_val, const char *path_0, int &v1, int &v2, int &v3)
{
	if (! CFG_check_list (key_val, path_0, 3))
	{
		return (false);
	}

	const std::list <ConfigKey> &	key_list = key_val.get_list ();
	std::list <ConfigKey>::const_iterator	it = key_list.begin ();

	if (CFG_get_int (it->get_value (), (String (path_0) + "/parameter 1").c_str (), v1))
	{
		return (false);
	}
	++ it;

	if (CFG_get_int (it->get_value (), (String (path_0) + "/parameter 2").c_str (), v2))
	{
		return (false);
	}
	++ it;

	if (CFG_get_int (it->get_value (), (String (path_0) + "/parameter 3").c_str (), v3))
	{
		return (false);
	}

	return (true);
}



/* Noms separees par des virgules (',') */
bool	CFG_get_enum (const ConfigKeyValue &key_val, const char *path_0, int &val, const char *enum_list_0)
{
	int		new_val;

	if (! CFG_check_string (key_val, path_0))
	{
		return (false);
	}

	String	str = key_val.get_string ();
	String	enum_list (enum_list_0);
	new_val = 0;
	while (enum_list.get_len () > 0)
	{
		int	len = enum_list.find (',');
		if (len < 0)
		{
			len = enum_list.get_len ();
		}

		String	item (enum_list.left (len));
		if (BASE_compare_string (str.c_str (), item.c_str ()) == 0)
		{
			break;
		}

		enum_list = enum_list.after (len);
		new_val ++;
	}

	if (enum_list.get_len () <= 0)
	{
		LOG_printf ("CFG_get_enum: Warning: (in \"%s\") parameter \"%s\" is not in the possible values (%s).\n",
		            path_0, str.c_str (), enum_list_0);
		return (false);
	}

	val = new_val;

	return (true);
}



bool	CFG_check_string (const ConfigKeyValue &key_val, const char *path_0)
{
	if (key_val.get_type () != ConfigKeyValue_Type_STRING)
	{
		LOG_printf ("CFG_check_string: Warning: (in \"%s\") single value expected as parameter.\n", path_0);
		return (false);
	}

	return (true);
}



bool	CFG_check_list (const ConfigKeyValue &key_val, const char *path_0, int nbr_items)
{
	if (key_val.get_type () != ConfigKeyValue_Type_LIST)
	{
		LOG_printf ("CFG_check_string: Warning: (in \"%s\") list expected as parameter.\n", path_0);
		return (false);
	}

	if (nbr_items > 0)
	{
		if (key_val.get_list ().size () != nbr_items)
		{
			LOG_printf ("CFG_check_string: Warning: (in \"%s\") expected %d items in parameter list.\n",
			            path_0, nbr_items);
			return (false);
		}
	}

	return (true);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
