/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (ENV_CURRENT_HEADER)
	#error Inclusion recursive du header ENV.
#endif
#define	ENV_CURRENT_HEADER

#if ! defined (ENV_HEADER_INCLUDED)
#define	ENV_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"Envelope.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	ENV_init (void);
void	ENV_restore (void);

WORD	ENV_get_flags (int env_type, int env);
void	ENV_set_flags (int env_type, int env, WORD flags);
int	ENV_get_nbr_points (int env_type, int env);
void	ENV_set_nbr_points (int env_type, int env, int nbr_points);
Envelope_POINT	ENV_get_point (int env_type, int env, int pos);
void	ENV_set_point (int env_type, int env, int pos, const Envelope_POINT &point);
Envelope_LOOP	ENV_get_loop (int env_type, int env, int type);
void	ENV_set_loop (int env_type, int env, int type, const Envelope_LOOP &loop);
UWORD	ENV_get_lfo_speed (int env_type, int env);
void	ENV_set_lfo_speed (int env_type, int env, UWORD val);
UWORD	ENV_get_lfo_depth (int env_type, int env);
void	ENV_set_lfo_depth (int env_type, int env, UWORD val);
UWORD	ENV_get_lfo_sweep (int env_type, int env);
void	ENV_set_lfo_sweep (int env_type, int env, UWORD val);
UWORD	ENV_get_fadeout (int env_type, int env);
void	ENV_set_fadeout (int env_type, int env, UWORD val);
int	ENV_get_lfo_waveform (int env_type, int env);
void	ENV_set_lfo_waveform (int env_type, int env, int val);

void	ENV_start (int env_type, int env, Envelope_PROCESS &proc);
void	ENV_process_tick (int env_type, int env, Envelope_PROCESS &proc);

signed int	ENV_kill_envelope (int env_type, int env);

long	ENV_get_length_in_ticks (int env_type, int env, int last_point = Envelope_MAX_NBR_POINTS);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ENV_CURRENT_HEADER
