/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	<crtdbg.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"errors.h"
#include	"log.h"



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ VARIABLES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Adresse de la zone memoire que l'on veut surveiller */
UBYTE	*ERR_mem_guardian_ptr = NULL;

/* Taille de la zone memoire a surveiller */
long	ERR_mem_guardian_zone_length = 0;

/* Somme de controle de la zone memoire */
unsigned long	ERR_mem_guardian_checksum = 0;



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



signed int	ERR_init (void)
{
	int		old_flags;

	_CrtSetReportMode (_CRT_WARN, _CRTDBG_MODE_WNDW);
	_CrtSetReportMode (_CRT_ERROR, _CRTDBG_MODE_WNDW);
	_CrtSetReportMode (_CRT_ASSERT, _CRTDBG_MODE_WNDW);
	
	old_flags = _CrtSetDbgFlag (_CRTDBG_REPORT_FLAG);
	_CrtSetDbgFlag (
		  old_flags
	   | (0 * _CRTDBG_CHECK_ALWAYS_DF)		// Verification de toute le memoire a chaque allocation
	   | (1 * _CRTDBG_LEAK_CHECK_DF)
	   | (0 * _CRTDBG_CHECK_ALWAYS_DF)
	   | (0 * _CRTDBG_DELAY_FREE_MEM_DF)
	);

	return (0);
}



void	ERR_restore (void)
{
}



/****************************************************************************/
/*                                                                          */
/*      ROUTINES DE VERIFICATION DE L'INTEGRITE D'UNE ZONE MEMOIRE          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom: ERR_mem_guardian_init                                          */
/*      Description: Specifie le bloc de zone memoire a surveiller.         */
/*      Parametres en entree:                                               */
/*        - zone_ptr: pointeur sur la zone a surveiller.                    */
/*        - length: longueur de la zone en octets.                          */
/*==========================================================================*/

void	ERR_mem_guardian_init (void *zone_ptr, long length)
{
	ERR_mem_guardian_ptr = (UBYTE *)zone_ptr;
	ERR_mem_guardian_zone_length = length;
	ERR_mem_guardian_checksum = ERR_compute_checksum (ERR_mem_guardian_ptr,
	                                                  ERR_mem_guardian_zone_length);
}



/*==========================================================================*/
/*      Nom: ERR_mem_guardian_check                                         */
/*      Description: Regarde si la zone a ete corrompue par un test de      */
/*                   checksum.                                              */
/*      Retour: 0 si tout est normal.                                       */
/*==========================================================================*/

signed int	ERR_mem_guardian_check (void)
{
	if (   ERR_compute_checksum (ERR_mem_guardian_ptr,
	                             ERR_mem_guardian_zone_length)
	    != ERR_mem_guardian_checksum)
	{
		LOG_printf ("ERR_mem_guardian_check: Error: data seems to be corrupted.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: ERR_compute_checksum                                           */
/*      Description: Calcule la checksum d'un bloc memoire.                 */
/*      Parametres en entree:                                               */
/*        - zone_ptr: pointeur sur la zone a surveiller.                    */
/*        - length: longueur de la zone en octets.                          */
/*      Retour: la somme de controle.                                       */
/*==========================================================================*/

unsigned long	ERR_compute_checksum (UBYTE *zone_ptr, long length)
{
	unsigned long	sum;
	long		cnt;

	sum = 0;
	for (cnt = 0; cnt < length; cnt ++)
	{
		sum += (unsigned long)(*zone_ptr++) * ((cnt % 7) + 1);
	}

	return (sum);
}



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/

signed int	ERR_check_all (void)
{
	signed int	ret_val;

	ret_val = 0;

	if (! _CrtCheckMemory ())
	{
		LOG_printf ("OS_check_all: Error: _CrtCheckMemory failed.\n");
		ret_val = -1;
	}

	/*** A finir ***/

	return (ret_val);
}



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
