/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (MIX_CURRENT_HEADER)
	#error Inclusion recursive du header MIX.
#endif
#define	MIX_CURRENT_HEADER

#if ! defined (MIX_HEADER_INCLUDED)
#define	MIX_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"gt_limit.h"



/*\\\ CONSTANTES ET MACROS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	MIX_MAX_FRAME_LENGTH			1024
#define	MIX_INIT_BUFFER_ZONE_SIZE	(GTK_NBRTRACKS_MAXI * GTK_NBROUT_MAXI * MIX_MAX_FRAME_LENGTH)
#define	MIX_CD_REPLAY_FREQ			44100

/* Qualite de mixage */
enum
{
	MIX_SOUND_QUALITY_NORMAL = 0,
	MIX_SOUND_QUALITY_BEST
};

/* Largeur du filtre de reconstruction, en samples. Doit etre pair. */
#define	MIX_INIT_RECONS_FLITER_WIDTH		64



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	MIX_init ();
void	MIX_restore ();

int	MIX_get_sound_quality ();
signed int	MIX_set_sound_quality (int quality);

void	MIX_create_mix_buffers ();
void	MIX_create_mix_array ();
void	MIX_do_mix ();
void	MIX_do_not_mix ();

void	MIX_set_sample_group (int group);
int	MIX_get_sample_group ();



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern LWORD	MIX_replay_freq;
extern LWORD	MIX_latency_time_ms;
extern LWORD	MIX_buffer_zone_size;

extern LWORD	MIX_frame_length;
extern float *	MIX_driver_out_buffer_ptr [GTK_NBROUT_MAXI];
extern float *	MIX_driver_in_buffer_ptr [GTK_NBRIN_MAXI];

extern int	MIX_recons_filter_width;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MIX_CURRENT_HEADER
