/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (RSC_CURRENT_HEADER)
	#error Inclusion recursive du header RSC.
#endif
#define	RSC_CURRENT_HEADER

#if ! defined (RSC_HEADER_INCLUDED)
#define	RSC_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#if ! defined (RED_RESOURCE_EDITOR)

#include	<time.h>

#include "archi.h"
#include	"base_ct.h"
#include	"Image.h"
#include	"rsc01.h"
#include	"Skin.h"

#endif



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Nombre d'objets que peut fabriquer le programme apres chargement des resources */
#define	RSC_NBR_CUSTOM_OBJECTS		1024

/* Fonte */
#define	RSC_PIXEL_RATIO			1					/* 1 si pixels carres, 2 si rect */
#define	RSC_CHAR_W					8					/* Largeur en pixels */
#define	RSC_CHAR_H					(12/RSC_PIXEL_RATIO)	/* Hauteur en pixels */
#define	RSC_V_SPACE					(4/RSC_PIXEL_RATIO)	/* Nombre de lignes (pixels) a sauter entre deux lignes de textes */

#define	RSC_RESOURCE_FILE_NAME	"rsc01.rsc"		/* Nom du fichier resource */

enum	RSC_object_numbers
{
	RSC_OBJECT_NUMBER_NULL = 0x0,
	RSC_OBJECT_NUMBER_POINT,
	RSC_OBJECT_NUMBER_HLINE,
	RSC_OBJECT_NUMBER_VLINE,
	RSC_OBJECT_NUMBER_BOX,
	RSC_OBJECT_NUMBER_XORBOX,
	RSC_OBJECT_NUMBER_BITMAP,
	RSC_OBJECT_NUMBER_TBITMAP,
	RSC_OBJECT_NUMBER_TEXT,
	RSC_OBJECT_NUMBER_TTEXT,

	RSC_OBJECT_NUMBER_INTBOX = 0x101,
	RSC_OBJECT_NUMBER_EXTBOX,
	RSC_OBJECT_NUMBER_BOXTEXT,
	RSC_OBJECT_NUMBER_EDBOXTEXT,
	RSC_OBJECT_NUMBER_BUTTON
};

/* Attributs de base */
#define	RSC_ATTR_NOTDISP		0x0001	/* Ne pas afficher l'objet et ses fils, et ne pas faire de test de clic dessus. */
#define	RSC_ATTR_DISABLE		0x0002	/* Objet grise (mais peut etre toujours selectionne) */
#define	RSC_ATTR_NOCLICK		0x0004	/* Pas de test de clic sur cet objet */
#define	RSC_ATTR_SELECTABLE	0x0008	/* L'objet peut devenir Selected en cas de clic */
#define	RSC_ATTR_SELECTED		0x0010	/* Indique que l'objet a ete selectionne */
#define	RSC_ATTR_PERMANENT	0x0020	/* Ne se deselectionne pas automatiquement */
#define	RSC_ATTR_RADIO			0x0040	/* Un seul bouton possible parmi tous ses freres Radio */
#define	RSC_ATTR_TOUCHEXIT	0x0080	/* Le bouton a un effet immediat (n'attend pas de relachement). Implicite si l'objet n'est pas SELECTABLE */
#define	RSC_ATTR_NOTEMPO		0x0100	/* Indique qu'on ne veut pas de temporisation entre deux evenements (destine a completer RSC_ATTR_TOUCHEXIT pour les sliders) */
#define	RSC_ATTR_CAPTURE		0x0200	/* Le bouton reste selectionne tant qu'on maintient la souris appuyee, meme si elle a quitte le bouton (pour les sliders) */
#define	RSC_ATTR_ONRELEASE	0x0400	/* Pour les Touchexit, valide l'objet aussi quand on vient de le relacher */
#define	RSC_ATTR_HIDECHILD	0x8000	/* Cache les enfants de l'objet dans la liste des objets. Utilise uniquement par RSC_EDIT. */

/* Attributs "preassembles" */

/* Zone de l'ecran a clic detectable */
#define	RSC_ATTRP_CLICKONLY	(RSC_ATTR_TOUCHEXIT)
/* Bouton a retour automatique */
#define	RSC_ATTRP_BUT     	(RSC_ATTR_SELECTABLE)
/* Bouton sans retour */
#define	RSC_ATTRP_PBUT			(RSC_ATTR_SELECTABLE | RSC_ATTR_PERMANENT | RSC_ATTR_TOUCHEXIT)
/* Radio-bouton */
#define	RSC_ATTRP_RBUT			(RSC_ATTR_SELECTABLE | RSC_ATTR_PERMANENT | RSC_ATTR_RADIO | RSC_ATTR_TOUCHEXIT)
/* Bouton d'action continue (ex: fleches) */
#define	RSC_ATTRP_CONT			(RSC_ATTR_SELECTABLE | RSC_ATTR_TOUCHEXIT)
/* Element de decor */
#define	RSC_ATTRP_DECOR		(RSC_ATTR_NOCLICK)
/* Element non acheve */
#define	RSC_ATTRP_DISABLE		(RSC_ATTR_DISABLE | RSC_ATTR_NOCLICK)
/* Clic detectable a reponse rapide */
#define	RSC_ATTRP_FASTREP		(RSC_ATTRP_CLICKONLY | RSC_ATTR_NOTEMPO)
/* Barre du slider */
#define	RSC_ATTRP_SLIDER		(RSC_ATTRP_CONT | RSC_ATTR_NOTEMPO | RSC_ATTR_CAPTURE)

/* Hauteur d'un BOXTEXT a une ligne */
#define	RSC_BOXTEXT_H			((RSC_CHAR_H) + 8)

/* Type des objets INTBOX */
#define	RSC_INTBOX_T_GREY		0
#define	RSC_INTBOX_T_BLUE		1

/* Type des objets EXTBOX */
#define	RSC_EXTBOX_T_GREY		0		/* Gris normal */
#define	RSC_EXTBOX_T_BLUE		1		/* Gris bleute */
#define	RSC_EXTBOX_T_BLACKG	2		/* Noir, enfonce, bords gris normal */
#define	RSC_EXTBOX_T_BLACKB	3		/* Noir, enfonce, bords gris bleute */
#define	RSC_EXTBOX_T_BLUEG	4		/* Bleu, enfonce, bords gris normal */
#define	RSC_EXTBOX_T_BLUEB	5		/* Bleu, enfonce, bords gris bleute */

/* Types des objets BOXTEXT */
#define	RSC_BOXTEXT_T_GREY	0		/* Gris normal */
#define	RSC_BOXTEXT_T_BLUE	1		/* Gris bleute */

/* Type des objets EDBOXTEXT */
#define	RSC_EDBOXTEXT_T_GREY	0		/* Bleu sur fond noir, enfonce, bords de cadre gris normal */
#define	RSC_EDBOXTEXT_T_BLUE	1		/* Bleu sur fond noir, enfonce, bords de cadre gris bleute */

/* Justifications */
#define	RSC_BOXTEXT_J_CENTER	0
#define	RSC_BOXTEXT_J_LEFT	1
#define	RSC_BOXTEXT_J_RIGHT	2

/* Types des objets BUTTON */
#define	RSC_BUTTON_T_NONE		(-1)	/* Aucun type particulier (simple icone) */
#define	RSC_BUTTON_T_UARROW	0		/* Fleches */
#define	RSC_BUTTON_T_DARROW	1
#define	RSC_BUTTON_T_LARROW	2
#define	RSC_BUTTON_T_RARROW	3
#define	RSC_BUTTON_T_RRADIO	4		/* Radio-bouton de selection */
#define	RSC_BUTTON_T_CROSS	5		/* Bouton de selection (croix) */

/* Types complementaires des objets BUTTON */
#define	RSC_BUTTON_T2_NONE	(-1)	/* Aucun type particulier (simple icone) */
#define	RSC_BUTTON_T2_GREY	0
#define	RSC_BUTTON_T2_BLUE	1



#ifndef RED_RESOURCE_EDITOR

/* Objets graphiques charges en memoire */
enum
{
	RSC_GFX_FONT = 0,
	RSC_GFX_VUMETRE_H_DARK,
	RSC_GFX_VUMETRE_H_BRIGHT,
	RSC_GFX_KNOB_1_H_G,
	RSC_GFX_KNOB_2_H_B,
	RSC_GFX_KNOB_2_V_B,
	RSC_GFX_PANMETRE_112,

	RSC_GFX_TOTAL_NBR
};

#endif



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*______________________________________________
 *
 * Objets de l'interface
 *______________________________________________
 */

typedef struct
{
	int		primitive;
	LWORD		attributes;
	union {
		LWORD		number;
		void		*ptr;
	}			child;

	union {
		LWORD		number;
		void		*ptr;
	}			brother;
	signed int	x;
	signed int	y;
} RSC_OBJTYPE_HEADER;

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
} RSC_OBJTYPE_NULL;			/* 0000 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		c;
} RSC_OBJTYPE_POINT;			/* 0001 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		l;
	int		c;
} RSC_OBJTYPE_HLINE;			/* 0002 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		h;
	int		c;
} RSC_OBJTYPE_VLINE;			/* 0003 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		l, h;
	int		c;
} RSC_OBJTYPE_BOX;			/* 0004 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		l, h;
	int		c;
} RSC_OBJTYPE_XORBOX;		/* 0005 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		img [3];			/* Normal, selected, disable */
} RSC_OBJTYPE_BITMAP;		/* 0006 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		img [3];			/* Normal, selected, disable */
} RSC_OBJTYPE_TBITMAP;		/* 0007 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		c;
	char		*text_0;
} RSC_OBJTYPE_TEXT;			/* 0008 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		c;
	char		*text_0;
} RSC_OBJTYPE_TTEXT;			/* 0009 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		l, h;
	int		t;
} RSC_OBJTYPE_INTBOX;		/* 0101 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		l, h;
	int		t;
} RSC_OBJTYPE_EXTBOX;		/* 0102 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		l, h;
	int		t;
	int		j;
	char		*text_0;
} RSC_OBJTYPE_BOXTEXT;		/* 0103 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		l;
	int		t;
	char		*text_0;
} RSC_OBJTYPE_EDBOXTEXT;	/* 0104 */

typedef struct
{
	RSC_OBJTYPE_HEADER	header;
	int		t;
	int		t2;
	int		img [3];			/* Normal, selected, disable */
} RSC_OBJTYPE_BUTTON;		/* 0105 */



/* Les instructions suivantes ne concernent pas l'editeur de resource */
#ifndef RED_RESOURCE_EDITOR

/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	RSC_init_resource (void);
void	RSC_restore_resource (void);
int	RSC_load_resource_file (const char *filename_0);
signed int	RSC_set_skin (const char *path_0);
Image	*RSC_pcxload (const char *name_0, LWORD pal_ptr [256]);
long	RSC_get_object_len (int object_type);
int	RSC_duplicate_object (int object, bool brother_flag = false);
void	RSC_delete_object (int object, bool brother_flag = false);
int	RSC_get_brother (int object);
int	RSC_get_child (int object);
int	RSC_get_width (int object);
void	RSC_set_width (int object, int l);
int	RSC_get_height (int object);
void	RSC_set_height (int object, int h);
int	RSC_get_color (int object);
void	RSC_set_color (int object, int c);
char	*RSC_get_string (int object);
signed int	RSC_set_string (int object, const char *text_0);
void	RSC_select_object_display (int object, bool flag);
void	RSC_select_radio_button (int object, int aine);
void	RSC_select_radio_button_display (int object, int aine);
void	RSC_set_flag (int object, LWORD flag);
void	RSC_clear_flag (int object, LWORD flag);
void	RSC_pos_flag (int object, LWORD flag, bool state);
bool	RSC_test_flags (int object, LWORD flag);
bool	RSC_test_all_flags (int object, LWORD flag);
void	RSC_set_absolute_object_position (int object, int pixxpos, int pixypos);
void	RSC_set_relative_object_position (int object, int rel_pixxpos, int rel_pixypos);
void	RSC_get_relative_object_position (int object, int &rel_pixxpos, int &rel_pixypos);
void	RSC_set_absolute_object_position_rec (int object, int pixxpos, int pixypos, bool brother_flag);
bool	RSC_is_child (int object, int father);
signed int	RSC_get_pointed_object_number (int mouse_x, int mouse_y, int father, int *aine_ptr);
void	RSC_get_pointed_object_number_rec (int mouse_x, int mouse_y, int object, int	aine, int current_level, int *pointed_level_ptr, int *pointed_ptr, int	*pointed_aine_ptr, bool brother_flag);
void	RSC_gere_resource (int father, int *sel_object_ptr, int *sel_aine_ptr);
void	RSC_flush_resource (void);
Image	*RSC_get_gfx_ptr (int gfx);

void	RSC_display_object (int object, bool child_flag = true);
void	RSC_display_image (Image *image_ptr, int src_x, int src_y, int src_w, int src_h, int object, int dest_x, int dest_y);
void	RSC_display_image (Image *image_ptr, int src_x, int src_y, int src_w, int src_h, int object, int dest_x, int dest_y, int t_color);
void	RSC_display_point (int object, int x, int y, int color);
void	RSC_display_line (int object, int x1, int y1, int x2, int y2, int color, LWORD pattern = 0xFFFFFFFF);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern const char	RSC_pic_directory_0 [];
extern const char	RSC_font_filename_0 [];

extern Skin	*RSC_skin_ptr;
extern int	RSC_gfx_nbr [RSC_GFX_TOTAL_NBR];

extern RSC_OBJTYPE_HEADER	*RSC_object_ptr [RSC_NBROBJECTS_MAXI+RSC_NBR_CUSTOM_OBJECTS];
extern int		RSC_absolute_object_pixxpos [RSC_NBROBJECTS_MAXI+RSC_NBR_CUSTOM_OBJECTS];
extern int		RSC_absolute_object_pixypos [RSC_NBROBJECTS_MAXI+RSC_NBR_CUSTOM_OBJECTS];
extern clock_t	RSC_click_time_base;

extern int	RSC_info_line_len;

extern int	RSC_mouse_key;

#endif



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef RSC_CURRENT_HEADER
