#include	<windows.h>
#include	"pc.h"



int	OS_key_pressed (void)
{
	HANDLE	console;
	INPUT_RECORD	buffer;
	DWORD		nbr;

	console = GetStdHandle (STD_INPUT_HANDLE);
	for ( ; ; )
	{
		PeekConsoleInput (console, &buffer, 1, &nbr);
		if (nbr <= 0)
		{
			break;
		}

		/* On ne s'interesse qu'aux entrees clavier, touches enfoncees */
		if (buffer.EventType == KEY_EVENT)
		{
			if (buffer.Event.KeyEvent.bKeyDown)
			{
				break;
			}
		}

		/* Efface l'evenement courant du buffer d'entree */
		ReadConsoleInput (console, &buffer, 1, &nbr);
	}

	return (nbr > 0);
}



int	OS_get_key (void)
{
	int		key;
	HANDLE	console;
	INPUT_RECORD	buffer;
	DWORD		nbr;

	console = GetStdHandle (STD_INPUT_HANDLE);
	for ( ; ; )
	{
		ReadConsoleInput (console, &buffer, 1, &nbr);
		if (buffer.EventType == KEY_EVENT)
		{
			if (buffer.Event.KeyEvent.bKeyDown)
			{
				break;
			}
		}
	}
	key = buffer.Event.KeyEvent.uChar.AsciiChar;

	switch (buffer.Event.KeyEvent.wVirtualScanCode)
	{
	case	0x01:	key = 0x01;	break;	/* Esc */
	case	0x1C:	key = 0x02;	break;	/* Enter */
	case	0x48:	key = 0x03;	break;	/* Up */
	case	0x50:	key = 0x04;	break;	/* Down */
	case	0x4B:	key = 0x05;	break;	/* Left */
	case	0x4D:	key = 0x06;	break;	/* Right */
	case	0x52:	key = 0x07;	break;	/* Insert */
	case	0x53:	key = 0x08;	break;	/* Delete */
	default:
		if (key >= 59 && key <= 68)
		{
			key = key - 59 + 20;
		}
	}

	return (key);
}



void	OS_clear_screen (void)
{
	HANDLE	console;
	const COORD	coord =
	{
		OS_NBR_COLUMNS, OS_NBR_LINES
	};
	const COORD	topleft = { 0, 0 };
	const SMALL_RECT	rect =
	{
		0, 0,
		OS_NBR_COLUMNS - 1, OS_NBR_LINES - 1
	};
	DWORD	bidon;

	console = GetStdHandle (STD_OUTPUT_HANDLE);
	SetConsoleScreenBufferSize (console, coord);
	SetConsoleWindowInfo (console, true, &rect);
	FillConsoleOutputCharacter (console, ' ', OS_NBR_COLUMNS * OS_NBR_LINES, topleft, &bidon);
}



void	OS_locate (int x, int y)
{
	HANDLE	console;
	COORD		coord;

	coord.X = x - 1;
	coord.Y = y - 1;
	console = GetStdHandle (STD_OUTPUT_HANDLE);
	SetConsoleCursorPosition (console, coord);
}



void	OS_print (char	*text_0)
{
	HANDLE	console;
	DWORD		nbr;

	console = GetStdHandle (STD_OUTPUT_HANDLE);
	WriteConsole (console, text_0, ::DWORD (strlen (text_0)), &nbr, 0);
}



void	OS_print_at (int x, int y, char *text_0)
{
	OS_locate (x, y);
	OS_print (text_0);
}