/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (SLID_CURRENT_HEADER)
	#error Inclusion recursive du header SLID.
#endif
#define	SLID_CURRENT_HEADER

#if ! defined (SLID_HEADER_INCLUDED)
#define	SLID_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

enum
{
	SLID_DIRECTION_VERTICAL = 0,	/* Orientation des sliders */
	SLID_DIRECTION_HORIZONTAL
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	int		sbar_object;
	int		slider_object;
	int		pix_pos;
	int		pix_win;
	long		virtual_len;
	long		virtual_pos;
	long		virtual_win;
	signed int	glisse_pos;	/* -2: on a bouge en cliquant sur le cote, */
									/* -1: on n'a pas bouge, */
									/* 0-... : on est en train de glisser, offset de la souris par rapport au slider */
	int		direction;
	bool		changed_pos_flag;	/* Indique qu'on a change de position depuis la derniere fois */
	bool		no_graphic_limit_flag;	/* Indique qu'on n'est plus limite par le slider graphique mais par les limites suivantes */
	long		inf;
	long		sup;
} SLID_INFO;



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

void	SLID_display_slider (SLID_INFO *slider_ptr);
void	SLID_gere_slider (SLID_INFO *slider_ptr, int sel_object);
void	SLID_check_slider (SLID_INFO *slider_ptr);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SLID_CURRENT_HEADER
