/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (ConfigFile_CURRENT_HEADER)
	#error Inclusion recursive du header ConfigFile.
#endif
#define	ConfigFile_CURRENT_HEADER

#if ! defined (ConfigFile_HEADER_INCLUDED)
#define	ConfigFile_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"ConfigKey.h"

#include	<list>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Codes d'erreurs de la fonction read () */
#define	ConfigFile_INTERNAL_ERROR			(-1L)
#define	ConfigFile_OK							0L
#define	ConfigFile_NON_CLOSED_QUOTES		0x10000L
#define	ConfigFile_NON_CLOSED_BRACKETS	0x20000L
#define	ConfigFile_NON_OPENED_BRACKETS	0x30000L
#define	ConfigFile_MISSING_PARAMETER		0x40000L

/* Nombre maximum de lexemes dans le fichier de config (en moyenne 3-4 par ligne) */
#define	ConfigFile_MAX_NBR_LEXEMES			10000



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class ConfigFile
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const char	delimiter_list_0 [];



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
ConfigFile (const char *filename_0);
~ConfigFile (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed long	read (std::list <ConfigKey> &key_list);
signed int	write (const std::list <ConfigKey> &key_list);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
char		*read_text (FILE *file_ptr);
signed long	remove_comments (char *text_0);
signed long	isolate_brackets (char **text_0_ptr);
signed long	get_key_list (std::list <ConfigKey> &key_list, char *lex_0_array [], long &index);




/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
char		*_filename_0;	// Pointeur sur le nom du fichier



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
ConfigFile (void);
ConfigFile (const ConfigFile &other);
void		operator = (const ConfigFile &other);
int		operator == (const ConfigFile &other) const;
int		operator != (const ConfigFile &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ConfigFile_CURRENT_HEADER
