/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"ConfigKey.h"
#include	"ConfigKeyValue.h"

#include	<cassert>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

ConfigKey::ConfigKey ()
:	_name ()
,	_value_ptr (0)
{
	// Nothing
}



ConfigKey::ConfigKey (const char *name_0, const ConfigKeyValue &val)
:	_name (name_0)
,	_value_ptr (val.clone ())
{
	// Nothing
}



ConfigKey::ConfigKey (const ConfigKey &other)
:	_name (other._name)
,	_value_ptr (other._value_ptr->clone ())
{
	// Nothing
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

ConfigKey::~ConfigKey ()
{
	if (_value_ptr != 0)
	{
		delete _value_ptr;
		_value_ptr = 0;
	}
}



void	ConfigKey::set_name (const char *name_0)
{
	_name = name_0;
}



String	ConfigKey::get_name () const
{
	return (_name);
}



ConfigKeyValue	&	ConfigKey::get_value () const
{
	assert (_value_ptr != 0);

	return (*_value_ptr);
}



void	ConfigKey::set_value (const ConfigKeyValue &val)
{
	ConfigKeyValue *	temp_ptr = val.clone ();

	if (_value_ptr != 0)
	{
		delete _value_ptr;
		_value_ptr = 0;
	}

	_value_ptr = temp_ptr;
}



String	ConfigKey::get_string () const
{
	return (get_value ().get_string ());
}



std::list <ConfigKey> &	ConfigKey::get_list ()
{
	return (get_value ().get_list ());
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
