/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if ! defined (Drumpad_HEADER_INCLUDED)
#define	Drumpad_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250) // "Inherits via dominance."
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"mods_ct.h"



class Drumpad
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	enum {			NBR_SLOTS	= 64	};

						Drumpad ();
	virtual			~Drumpad () {}

	// Basic functions
	void				clear_all ();

	bool				is_slot_full (int index) const;
	void				get_slot (int index, MODS_GT2_SPL_NOTE &content) const;
	void				set_slot (int index, const MODS_GT2_SPL_NOTE &content);
	void				clear_slot (int index);

	// With the use of the GUI
	int				record_slot (int index);
	int				restitute_slot (int index) const;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	class Slot
	{
	public:
							Slot ();
		void				clear ();
		MODS_GT2_SPL_NOTE
							_note;
		bool				_full_flag;
	};

	typedef	Slot	SlotArr [NBR_SLOTS];

	SlotArr			_slot_arr;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

						Drumpad (const Drumpad &other);
	Drumpad &		operator = (const Drumpad &other);
	bool				operator == (const Drumpad &other);
	bool				operator != (const Drumpad &other);

};	// class Drumpad





//#include	"Drumpad.hpp"



#endif	// Drumpad_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
