/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<string.h>

#include	"archi.h"
#include	"base.h"
#include	"base_ct.h"
#include	"gt_limit.h"
#include	"log.h"
#include	"Instrument.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*        - number: numero de l'instrument cree.                            */
/*==========================================================================*/

Instrument::Instrument (int number)
{
	_number = number;

	init ();
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

Instrument::~Instrument (void)
{
	restore ();
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	Instrument::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("Instrument::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	Instrument::self_display (void) const
{

	/*** A faire ***/

}



void	Instrument::get_instr_name (char *name_0)
{
	BASE_copy_string (_name, name_0,
							Instrument_NAME_LEN, Instrument_NAME_LEN);
	name_0 [Instrument_NAME_LEN] = 0;
}



void	Instrument::set_instr_name (const char *name_0)
{
	BASE_copy_string (name_0, _name,
							strlen (name_0), Instrument_NAME_LEN);
}



int	Instrument::get_instr_volume (void)
{
	return (_volume);
}



void	Instrument::set_instr_volume (int volume)
{
	_volume = volume;
}



signed int	Instrument::get_instr_autobal (void)
{
	return (_autobal);
}



void	Instrument::set_instr_autobal (signed int balance)
{
	_autobal = balance;
}




int	Instrument::get_instr_sample (int note)
{
	return (_note [note].splnum);
}



void	Instrument::set_instr_sample (int note, int sample)
{
	_note [note].splnum = (UBYTE)sample;
}



signed int	Instrument::get_instr_transp (int note)
{
	return (_note [note].transp);
}



void	Instrument::set_instr_transp (int note, signed int transp)
{
	_note [note].transp = (SBYTE)transp;
}



int	Instrument::get_instr_zone_start (int note)
{
	int		sample;

	sample = get_instr_sample (note);
	note --;
	while (note > 0)
	{
		if (get_instr_sample (note) != sample)
		{
			break;
		}
		note --;
	}
	note ++;

	return (note);
}



int	Instrument::get_instr_zone_end (int note)
{
	int		sample;

	sample = get_instr_sample (note);
	note ++;
	while (note < GTK_NBRNOTES_MAXI)
	{
		if (get_instr_sample (note) != sample)
		{
			break;
		}
		note ++;
	}
	note --;

	return (note);
}



int	Instrument::get_instr_env (int type)
{
	return (_env [type]);
}



void	Instrument::set_instr_env (int type, int env)
{
	_env [type] = env;
}



bool	Instrument::get_filter_flag (void) const
{
	return (_filter_flag);
}



void	Instrument::set_filter_flag (bool flag)
{
	_filter_flag = flag;
}



bool	Instrument::get_filter_freq_vol_flag (void) const
{
	return (_filter_freq_vol_flag);
}



void	Instrument::set_filter_freq_vol_flag (bool flag)
{
	_filter_freq_vol_flag = flag;
}



bool	Instrument::get_filter_q_vol_flag (void) const
{
	return (_filter_q_vol_flag);
}



void	Instrument::set_filter_q_vol_flag (bool flag)
{
	_filter_q_vol_flag = flag;
}



double	Instrument::get_filter_freq (int type) const
{
	return (_filter_freq [type]);
}



void	Instrument::set_filter_freq (int type, double val)
{
	_filter_freq [type] = val;
}



double	Instrument::get_filter_q (int type) const
{
	return (_filter_q [type]);
}



void	Instrument::set_filter_q (int type, double val)
{
	_filter_q [type] = val;
}



signed int	Instrument::kill (void)
{
	restore ();

	return (init ());
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



signed int	Instrument::init (void)
{
	int		sample;
	int		type;

	memset (_name, ' ', Instrument_NAME_LEN);
	_volume = 0x100;
	_autobal = -1;
	for (type = 0; type < Envelope_NBR_TYPES; type ++)
	{
		_env [type] = 0;
	}

	_filter_flag = false;
	_filter_freq_vol_flag = false;
	_filter_q_vol_flag = false;
	_filter_freq [0] = 10000.0;
	_filter_freq [1] = 1000.0;
	_filter_q [0] = 0.5;
	_filter_q [1] = 0.5;

	sample = _number;
	for (int note = 0; note < GTK_NBRNOTES_MAXI; note ++)
	{
		_note [note].splnum = sample;
		_note [note].transp = 0;
	}

	return (0);
}



void	Instrument::restore (void)
{
	/* Rien */
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
