/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2015 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*Tab=3***********************************************************************/



#pragma once
#if ! defined (Meter_HEADER_INCLUDED)
#define	Meter_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



class Meter
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	               Meter ();
	
	void           set_sample_freq (double freq);
	void           clear_buffers ();
	void           process_block (const float data_ptr [], long buf_len, int nbr_voices);
	void           skip_block (long buf_len);
	double         get_peak () const;
	double         get_peak_hold () const;
	double         get_rms () const;
	void           clear_peak ();




/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	struct Decay
	{
		long           _hold_time;    // Samples
		double         _coef_r;
		double         _coef_r2;
		double         _coef_a2;
	};

	void           fix_tiny_values ();

	double         _sample_freq;     // Hz
	double         _peak_max;        // Maximum peak value
	double         _peak_hold;       // Hold value for peak
	long           _hold_counter;    // Counter for holding time (samples). Set to the maximum at a peak, and decreased. When reaching 0, the peak is set to the instantaneous value.
   double         _rms_sq;          // RMS value with an envelope, squared

	Decay          _dec [2];         // For mono and stereo



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               Meter (const Meter &other);
	bool           operator == (const Meter &other) const;
	bool           operator != (const Meter &other) const;

};	// class Meter



//#include	"Meter.hpp"



#endif	// Meter_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
