/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/




#if defined (PatEdMenuEnvWin_CURRENT_HEADER)
	#error Inclusion recursive du header PatEdMenuEnvWin.
#endif
#define	PatEdMenuEnvWin_CURRENT_HEADER

#if ! defined (PatEdMenuEnvWin_HEADER_INCLUDED)
#define	PatEdMenuEnvWin_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<time.h>

#include	"archi.h"
#include	"Envelope.h"
#include	"ICWindow.h"
#include	"inst.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	long		pos;
	long		size;
} PatEdMenuEnvWin_VIEW_CONF;

/* Memorisation de la vue pour chaque enveloppe */
typedef struct
{
	long		h_pos;
	long		v_pos;
	double	h_zoom;
	double	v_zoom;
} PatEdMenuEnvWin_ENV_VIEW;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PatEdMenuEnvWin
: public ICWindow
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PatEdMenuEnvWin (int master_object, int h_offset, int window, int center,
          signed int h_gadgets, signed int v_gadgets,
          signed int h_sbar, signed int h_slider,
          signed int v_sbar, signed int v_slider,
          signed int arrow_left, signed int arrow_right,
          signed int arrow_up, signed int arrow_down,
          signed int h_zoom_in, signed int h_zoom_out,
          signed int v_zoom_in, signed int v_zoom_out,
          long h_length, long v_length, long h_pos = 0, long v_pos = 0,
          double h_zoom = 1, double v_zoom = 1);

void		redraw (void);
void		refresh (void);
void		refresh_dynamic (bool force_flag);
void		manage (int sel_object, int sel_elder);

/* Redefinition des fonctions de ICWindow */
void		set_h_pos (long pos);
void		set_v_pos (long pos);
void		set_h_zoom (double zoom);
void		set_v_zoom (double zoom);

void		manage_main_window (int sel_object, int sel_elder);

void		reset_view (void);
void		restore_view (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static int	line_color;
static int	point_color;
static int	loop_color [Envelope_NBR_LOOPS];
static PatEdMenuEnvWin_ENV_VIEW	env_view [1+INST_NBRINSTR_MAXI] [Envelope_NBR_TYPES];



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const PatEdMenuEnvWin_VIEW_CONF	INIT_VIEW [Envelope_NBR_TYPES];



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_old_locked_point;
time_t	_last_click_time;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
PatEdMenuEnvWin (void);
PatEdMenuEnvWin (const PatEdMenuEnvWin &other);
void		operator = (const PatEdMenuEnvWin &other);
int		operator == (const PatEdMenuEnvWin &other) const;
int		operator != (const PatEdMenuEnvWin &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PatEdMenuEnvWin_CURRENT_HEADER
