/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"log.h"
#include	"PatEdMenuInstruments.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

enum
{
	PatEdMenuInstruments_SUBMENU_MAIN = 0,

	PatEdMenuInstruments_NBR_SUBMENUS
};



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

PatEdMenuInstruments::PatEdMenuInstruments (void)
{
	set_submenu (PatEdMenuInstruments_SUBMENU_MAIN);
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuInstruments::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuInstruments::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuInstruments::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuInstruments::redraw (void)
{
	switch (_submenu)
	{
	case	PatEdMenuInstruments_SUBMENU_MAIN:
		_main.redraw ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuInstruments::refresh (void)
{
	switch (_submenu)
	{
	case	PatEdMenuInstruments_SUBMENU_MAIN:
		_main.refresh ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuInstruments::refresh_dynamic (bool force_flag)
{
	switch (_submenu)
	{
	case	PatEdMenuInstruments_SUBMENU_MAIN:
		_main.refresh_dynamic (force_flag);
		break;
	}
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuInstruments::manage (int sel_object, int sel_elder)
{
	switch (sel_object)
	{
	case	RSC_OBJ_MP_SUBM_INSTR_PICN_MAIN:
		set_submenu (PatEdMenuInstruments_SUBMENU_MAIN);
		redraw ();
		break;

	default:
		switch (_submenu)
		{
		case	PatEdMenuInstruments_SUBMENU_MAIN:
			_main.manage (sel_object, sel_elder);
			break;
		}
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuInstruments::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_INSTR, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SMICN_INSTR, RSC_ATTR_SELECTED, activated_flag);
}



int	PatEdMenuInstruments::get_submenu (void) const
{
	return (_submenu);
}



void	PatEdMenuInstruments::set_submenu (int submenu)
{
	int		menu_cnt;
	bool		activate_flag;

	_submenu = submenu;

	/* Activation des menus */
	for (menu_cnt = 0; menu_cnt < PatEdMenuInstruments_NBR_SUBMENUS; menu_cnt ++)
	{
		activate_flag = (menu_cnt == _submenu);

		switch (menu_cnt)
		{
		case	PatEdMenuInstruments_SUBMENU_MAIN:
			_main.activate (activate_flag);
			break;
		}
	}
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
