/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (PatEdMenuMix_CURRENT_HEADER)
	#error Inclusion recursive du header PatEdMenuMix.
#endif
#define	PatEdMenuMix_CURRENT_HEADER

#if ! defined (PatEdMenuMix_HEADER_INCLUDED)
#define	PatEdMenuMix_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"InterfaceComponent.h"
#include	"sliders.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Objets des sliders de volume et pan pour chaque ligne affichee */
typedef struct
{
	int		vol;
	int		pan;
} PatEdMenuMix_OBJECT_LINE;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PatEdMenuMix
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PatEdMenuMix (void);
~PatEdMenuMix (void);
signed int	check_ok (void) const;
void	self_display (void) const;

void	redraw (void);
void	refresh (void);
void	refresh_dynamic (bool force_flag);
void	manage (int sel_object, int sel_elder);

void	activate (bool activated_flag);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const char	*const PatEdMenuMix::track_type_name_0_ptr [5] [2];



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		clear_lines (void);
void		update_dest_track (bool force_flag);
void		update_source_tracks (bool force_flag);

signed int	set_mix_preset_number (int type, signed int value);
signed int	set_dest_track (int type, signed int value);
signed int	set_source_track_type (int type, signed int value, int win_line);
signed int	set_source_track (int type, signed int value, int win_line);

void        display_fader_gain (int obj, double peak, double rms, double volume);

double      pos_to_gain (double pos);
double      gain_to_pos (double g);
static const double  db_to_gain (double db);
static const double  gain_to_db (double g);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_dest_track_type;	/* Type de la piste destination */
int		_dest_track_nbr;	/* Numero de la piste destination */
bool		_dest_dry_flag;	/* Indique que la piste destination est dry (pour les FX) */
int		_disp_pos ;			/* Poisition d'affichage dans la fenetre des pistes sources */
int		_nbr_disp_lines;	/* Nombre de lignes affichables dans la fenetre */

SLID_INFO	_source_slider;

PatEdMenuMix_OBJECT_LINE	*_rsc_object_ptr;	// Tableau des numeros d'objets de chaque ligne pour panning et volume
int		_nbr_rsc_lines;	// Nombre de lignes de resource stoquees dans le tableau

class Point
{
public:
	double _pos;
	double _gain_db;
};

enum { FADER_MAP_SIZE = 5 };
static const Point	_fader_map [FADER_MAP_SIZE];



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PatEdMenuMix_CURRENT_HEADER
