/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"Patt.h"
#include	"PatEdMenuToolsTracks.h"
#include	"Pattern.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Objets pour chaque type de piste */
const int	PatEdMenuToolsTracks::track_objects [Pattern_NBR_TYPES] [3] =
{
	{
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_SPL_VAL,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_SPL_U,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_SPL_D
	},
	{
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_AIN_VAL,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_AIN_U,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_AIN_D
	},
	{
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_FX_VAL,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_FX_U,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_FX_D
	},
	{
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_MID_VAL,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_MID_U,
		RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_MID_D
	}
};



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuToolsTracks::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuToolsTracks::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuToolsTracks::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuToolsTracks::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuToolsTracks::refresh (void)
{
	int		object;
	int		track_type;
	int		total_tracks;
	char		string_0 [6+1];

	total_tracks = 0;
	for (track_type = 0; track_type < Pattern_NBR_TYPES; track_type ++)
	{
		object = track_objects [track_type] [0];
		sprintf (string_0, "%2d", GTK_nbr_tracks [track_type]);
		RSC_set_string (object, string_0);
		RSC_display_object (object);
		total_tracks += GTK_nbr_tracks [track_type];
	}

	sprintf (string_0, "%2d /%2d", total_tracks, GTK_NBRTRACKS_MAXI);
	RSC_set_string (RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_TOT_VAL, string_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_TOOLS_TRK_NUM_TOT_VAL);

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuToolsTracks::refresh_dynamic (bool force_flag)
{
	/* Rien en fait */
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuToolsTracks::manage (int sel_object, int sel_elder)
{
	int		track_type;

	for (track_type = 0; track_type < Pattern_NBR_TYPES; track_type ++)
	{
		/* Valeur */
		if (sel_object == track_objects [track_type] [0])
		{
			PAT_set_nbr_tracks_intr (INTR_CHGTYPE_KBD, 0, track_type);
			return;
		}

		/* Fleche vers le haut */
		else if (sel_object == track_objects [track_type] [1])
		{
			PAT_set_nbr_tracks_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], track_type);
			return;
		}

		/* Fleche vers le bas */
		else if (sel_object == track_objects [track_type] [2])
		{
			PAT_set_nbr_tracks_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], track_type);
			return;
		}
	}

	switch (sel_object)
	{
	/* Insertion */
	case	RSC_OBJ_MP_SUBM_TOOLS_TRK_INSDEL_INS:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);

		/*** A faire ***/

		break;

	/* Effacement */
	case	RSC_OBJ_MP_SUBM_TOOLS_TRK_INSDEL_DEL:
		INTR_dialog_box ("", "Not implemented.", "Cancel", 0, 0);

		/*** A faire ***/

		break;
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuToolsTracks::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_TOOLS_TRK, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_TOOLS_PICN_TRK, RSC_ATTR_SELECTED, activated_flag);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
