/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (PatEdMenus_CURRENT_HEADER)
	#error Inclusion recursive du header PatEdMenus.
#endif
#define	PatEdMenus_CURRENT_HEADER

#if ! defined (PatEdMenus_HEADER_INCLUDED)
#define	PatEdMenus_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"InterfaceComponent.h"
#include	"PatEdMenuEnvelopes.h"
#include	"PatEdMenuFiles.h"
#include	"PatEdMenuFx.h"
#include	"PatEdMenuInstruments.h"
#include	"PatEdMenuMidi.h"
#include	"PatEdMenuMix.h"
#include	"PatEdMenuPref.h"
#include	"PatEdMenuSamples.h"
#include	"PatEdMenuTools.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Identificateurs des differents sous-menus */
enum
{
	PatEdMenus_FILES = 0,
	PatEdMenus_TOOLS,
	PatEdMenus_INSTR,
	PatEdMenus_SPL,
	PatEdMenus_ENV,
	PatEdMenus_MIX,
	PatEdMenus_FX,
	PatEdMenus_MIDI,
	PatEdMenus_PREF,

	PatEdMenus_NBR_MENUS
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PatEdMenus
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PatEdMenus (void);
signed int	check_ok (void) const;
void	self_display (void) const;

void		redraw (void);
void		refresh (void);
void		refresh_dynamic (bool force_flag);
void		manage (int sel_object, int sel_elder);

int		get_width (void);
int		get_height (void);
void		get_coordinates (int &pix_x, int &pix_y);
void		move_to (int pix_x, int pix_y);

int		get_submenu (void) const;
void		set_submenu (int menu_nbr);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_submenu;

PatEdMenuFiles			_files;
PatEdMenuTools			_tools;
PatEdMenuInstruments	_instruments;
PatEdMenuSamples		_samples;
PatEdMenuEnvelopes	_envelopes;
PatEdMenuMix			_mix;
PatEdMenuFx				_effects;
PatEdMenuMidi			_midi;
PatEdMenuPref			_pref;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PatEdMenus_CURRENT_HEADER
